/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.visitors.ModificationsScanner;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Stream;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtVariable;

public class V6043
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("Consider inspecting the 'for' operator. Initial and final values of the iterator are the same.").setCwe(691).build();

    @Override
    public void visitCtFor(CtFor forLoop) {
        CtAssignment assignment;
        if (forLoop.getForInit().size() != 1 || forLoop.getExpression() == null) {
            return;
        }
        CtExpression initValue = null;
        CtVariable iterator = null;
        CtStatement initStatement = (CtStatement)forLoop.getForInit().get(0);
        if (initStatement instanceof CtVariable) {
            iterator = (CtVariable)initStatement;
            initValue = iterator.getDefaultExpression();
        } else if (initStatement instanceof CtAssignment && (assignment = (CtAssignment)initStatement).getAssigned() instanceof CtVariableAccess) {
            iterator = ((CtVariableAccess)assignment.getAssigned()).getVariable().getDeclaration();
            initValue = assignment.getAssigned();
        }
        if (iterator == null || initValue == null || !(forLoop.getExpression() instanceof CtBinaryOperator)) {
            return;
        }
        if (initValue instanceof CtAbstractInvocation) {
            return;
        }
        CtBinaryOperator condition = (CtBinaryOperator)forLoop.getExpression();
        if (condition.getKind() != BinaryOperatorKind.NE && condition.getKind() != BinaryOperatorKind.GE && condition.getKind() != BinaryOperatorKind.GT && condition.getKind() != BinaryOperatorKind.LE && condition.getKind() != BinaryOperatorKind.LT) {
            return;
        }
        CtExpression iterator2 = null;
        if (RulesUtils.equals((CtElement)condition.getLeftHandOperand(), (CtElement)initValue)) {
            iterator2 = condition.getRightHandOperand();
        } else if (RulesUtils.equals((CtElement)condition.getRightHandOperand(), (CtElement)initValue)) {
            iterator2 = condition.getLeftHandOperand();
        }
        if (!(iterator2 instanceof CtVariableAccess) || ((CtVariableAccess)iterator2).getVariable().getDeclaration() != iterator) {
            return;
        }
        CtExpression init = initValue;
        boolean isModified = Stream.of(forLoop.getForUpdate().stream(), Stream.of(forLoop.getBody())).flatMap(Function.identity()).map(e -> ModificationsScanner.scan((CtElement)e, this.getDataFlow().getVariablesCache()).keySet()).flatMap(Collection::stream).anyMatch(e -> RulesUtils.equals((CtElement)init, e));
        if (isModified) {
            return;
        }
        this.rule.add((CtElement)initValue, new Object[0]);
    }
}

