/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.Equality;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.utility.TypeArchitectureScanner;
import com.pvsstudio.warnings.WarningLevel;
import java.util.HashSet;
import java.util.Set;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtIntersectionTypeReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;

public class V6042
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("The expression is checked for compatibility with type 'A' but is cast to type 'B'.").setExtendedMessage("The expression is checked for compatibility with type '%s' but is cast to type '%s'.").setLevel(WarningLevel.LEVEL_2).setCwe(704).build();

    private void apply(CtExpression<?> condition, CtElement body) {
        if (!(condition instanceof CtBinaryOperator)) {
            return;
        }
        final CtBinaryOperator operator = (CtBinaryOperator)condition;
        if (operator.getKind() != BinaryOperatorKind.INSTANCEOF) {
            return;
        }
        if (!(operator.getRightHandOperand() instanceof CtTypeAccess)) {
            return;
        }
        final CtTypeReference type = ((CtTypeAccess)operator.getRightHandOperand()).getAccessedType();
        new CtScanner(){

            public <T> void visitCtConditional(CtConditional<T> conditional) {
            }

            public void visitCtIf(CtIf ifElement) {
            }

            public void scan(CtElement o) {
                super.scan(o);
                if (o instanceof CtExpression && V6042.this.isDifferentCast((CtExpression)o, (CtElement)operator.getLeftHandOperand(), type) && !V6042.this.isSuppressed(o, "unchecked")) {
                    V6042.this.rule.add(o, type, ((CtExpression)o).getTypeCasts().get(0));
                }
            }
        }.scan(body);
    }

    public void visitCtIf(CtIf ifElement) {
        this.apply(ifElement.getCondition(), (CtElement)ifElement.getThenStatement());
    }

    public <T> void visitCtConditional(CtConditional<T> conditional) {
        this.apply(conditional.getCondition(), (CtElement)conditional.getThenExpression());
    }

    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        if (operator.getKind() == BinaryOperatorKind.AND) {
            this.apply(operator.getLeftHandOperand(), (CtElement)operator.getRightHandOperand());
        }
    }

    private boolean isDifferentCast(CtExpression<?> expression, CtElement target, CtTypeReference<?> type) {
        try {
            if (expression.getTypeCasts().size() != 1) {
                return false;
            }
            CtTypeReference typeReference = type;
            if (type instanceof CtArrayTypeReference) {
                typeReference = ((CtArrayTypeReference)type).getArrayType();
            }
            if (typeReference.getTypeDeclaration() == null) {
                return false;
            }
            if (expression.getTypeCasts().get(0) instanceof CtIntersectionTypeReference && this.isTypesInBound(expression.getType(), type, ((CtTypeReference)expression.getTypeCasts().get(0)).asCtIntersectionTypeReference())) {
                return false;
            }
            CtTypeReference singleTypeCast = ((CtTypeReference)expression.getTypeCasts().get(0)).box();
            return RulesUtils.equals(target, expression, Equality.IGNORE_CASTS, new Equality[0]) && !type.isSubtypeOf(singleTypeCast);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isTypesInBound(CtTypeReference<?> objectType, CtTypeReference<?> checkedType, CtIntersectionTypeReference<?> intersectionTypeReference) {
        final HashSet bounds = new HashSet(intersectionTypeReference.getBounds());
        TypeArchitectureScanner.Config config = new TypeArchitectureScanner.Config().setInterfaceScanningEnableFlag(true).setParentClassesScanningEnableFlag(true).setParentInterfacesScanningEnableFlag(true);
        TypeArchitectureScanner scanner = new TypeArchitectureScanner<Set<CtTypeReference<?>>>(config){

            void visitTypeReference(CtTypeReference<?> ctTypeReference) {
                if (bounds.contains(ctTypeReference)) {
                    if (this.getResult() == null) {
                        this.setResult(new HashSet());
                    }
                    ((Set)this.getResult()).add(ctTypeReference);
                }
            }

            @Override
            public void visitClass(CtTypeReference<?> ctClass) {
                this.visitInterface(ctClass);
            }

            @Override
            public void visitInterface(CtTypeReference<?> ctInterface) {
                this.visitTypeReference(ctInterface);
            }

            @Override
            protected void visitEnum(CtTypeReference<?> ctEnum) {
                this.visitTypeReference(ctEnum);
            }
        };
        scanner.scan(objectType);
        scanner.scan(checkedType);
        return scanner.getResult() != null && bounds.size() == ((Set)scanner.getResult()).size();
    }
}

