/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.Value;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import java.util.List;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtWhile;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6041
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("Suspicious assignment inside the conditional expression of '%s' statement: '%s'.").setCwe(481).setSastId("CERT-EXP51-J").build();

    private void checkCondition(CtExpression<Boolean> condition, String operatorName) {
        List assignments = condition.filterChildren((Filter)new TypeFilter(CtAssignment.class)).list();
        for (CtAssignment assignment : assignments) {
            Value value;
            BinaryOperatorKind kind;
            if (assignment instanceof CtOperatorAssignment || !RulesUtils.isBooleanOrBoxed(assignment)) continue;
            CtExpression rhs = assignment.getAssignment();
            if (rhs instanceof CtBinaryOperator && ((kind = ((CtBinaryOperator)rhs).getKind()) == BinaryOperatorKind.AND || kind == BinaryOperatorKind.BITAND || kind == BinaryOperatorKind.OR || kind == BinaryOperatorKind.BITOR)) {
                rhs = ((CtBinaryOperator)rhs).getLeftHandOperand();
            }
            if (!(value = this.getValue((CtElement)rhs)).isTrue() && !value.isFalse()) continue;
            this.rule.add((CtElement)assignment, operatorName, assignment);
        }
    }

    public <T> void visitCtConditional(CtConditional<T> conditional) {
        this.checkCondition((CtExpression<Boolean>)conditional.getCondition(), "?:");
    }

    @Override
    public void visitCtWhile(CtWhile whileLoop) {
        this.checkCondition((CtExpression<Boolean>)whileLoop.getLoopingExpression(), "while");
    }

    @Override
    public void visitCtDo(CtDo doLoop) {
        this.checkCondition((CtExpression<Boolean>)doLoop.getLoopingExpression(), "do");
    }

    public void visitCtIf(CtIf ifElement) {
        this.checkCondition((CtExpression<Boolean>)ifElement.getCondition(), "if");
    }
}

