/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.List;
import java.util.Optional;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtContinue;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtWhile;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtTypeReference;

public class V6040
extends PvsStudioRule {
    private final PvsStudioRule.PatternBuilder ruleBuilder = new PvsStudioRule.PatternBuilder().setCwe(483);
    private final PvsStudioRule.Pattern rule = this.ruleBuilder.setMessage("The code's operational logic does not correspond with its formatting. The second statement will always be executed. It is possible that curly brackets are missing.").build();
    private final PvsStudioRule.Pattern rule2 = this.ruleBuilder.setMessage("The code's operational logic does not correspond with its formatting. The statement is indented to the right, but it is always executed. It is possible that curly brackets are missing.").build();

    private void impl(CtStatement curStatement, CtStatement nextStatement, CtStatement prevStatement, CtStatement body, boolean isPresentElse) {
        boolean isSecondErrorType;
        SourcePosition prevStatementPosition;
        if (!(body instanceof CtBlock) || !body.isImplicit() || ((CtBlock)body).getStatements().isEmpty()) {
            return;
        }
        SourcePosition bodyPosition = (body = ((CtBlock)body).getLastStatement()).getPosition();
        if (!bodyPosition.isValidPosition()) {
            return;
        }
        SourcePosition nextStatementPosition = nextStatement.getPosition();
        if (!nextStatementPosition.isValidPosition()) {
            return;
        }
        int bodyLine = bodyPosition.getEndLine();
        int nextLine = nextStatementPosition.getEndLine();
        if (prevStatement != null && (prevStatementPosition = prevStatement.getPosition()).isValidPosition() && prevStatementPosition.getEndLine() == nextLine) {
            return;
        }
        if (nextLine - bodyLine > 5) {
            return;
        }
        WarningLevel level = WarningLevel.LEVEL_1;
        boolean isError = false;
        if (bodyLine == nextLine) {
            boolean isOneLine = false;
            if (isPresentElse) {
                Optional<String> elseSourceLine = this.getModule().getLine(body.getPosition().getFile(), body.getPosition().getLine());
                if (elseSourceLine.isPresent() && elseSourceLine.get().contains("else")) {
                    isOneLine = true;
                }
            } else if (curStatement.getPosition().getLine() == bodyLine) {
                isOneLine = true;
            }
            if (isOneLine) {
                if (nextStatement instanceof CtIf || nextStatement instanceof CtFor || nextStatement instanceof CtWhile) {
                    return;
                }
                level = WarningLevel.LEVEL_2;
            }
            isError = true;
        }
        boolean bl = isSecondErrorType = nextLine - bodyLine == 1;
        if (isSecondErrorType) {
            int indentNext;
            if (body instanceof CtReturn) {
                return;
            }
            int indentCur = curStatement.getPosition().getColumn();
            if (nextStatement instanceof CtLocalVariable) {
                CtTypeReference type = ((CtLocalVariable)nextStatement).getType();
                if (!type.getPosition().isValidPosition()) {
                    return;
                }
                indentNext = type.getPosition().getColumn();
            } else {
                indentNext = nextStatement.getPosition().getColumn();
            }
            int indentBody = body.getPosition().getColumn();
            if (indentBody == indentNext && indentCur != indentNext) {
                Optional<String> bodySourceLine = this.getModule().getLine(body.getPosition().getFile(), body.getPosition().getLine());
                Optional<String> nextSourceLine = this.getModule().getLine(nextStatement.getPosition().getFile(), nextStatement.getPosition().getLine());
                if (bodySourceLine.isPresent() && nextSourceLine.isPresent()) {
                    long count2;
                    String indentNextStr = nextSourceLine.get().substring(0, indentNext);
                    String indentBodyStr = bodySourceLine.get().substring(0, indentBody);
                    long count1 = indentBodyStr.chars().filter(ch -> ch == 9).count();
                    if (count1 != (count2 = indentNextStr.chars().filter(ch -> ch == 9).count())) {
                        return;
                    }
                }
                isError = true;
                level = WarningLevel.LEVEL_2;
            }
        }
        if (body instanceof CtContinue || body instanceof CtBreak) {
            return;
        }
        if (isPresentElse && nextStatement instanceof CtBreak && nextStatement.getParent(CtSwitch.class) != null) {
            return;
        }
        if (!isError) {
            this.prepare(body, nextStatement, prevStatement);
            return;
        }
        if (isSecondErrorType) {
            this.rule2.add((CtElement)nextStatement, new Object[0]).setLevel(level);
        } else {
            this.rule.add((CtElement)nextStatement, new Object[0]).setLevel(level);
        }
    }

    private void prepare(CtStatement curStatement, CtStatement nextStatement, CtStatement prevStatement) {
        CtStatement body;
        boolean isPresentElse = false;
        if (curStatement instanceof CtIf) {
            CtIf ctIf = (CtIf)curStatement;
            if (ctIf.getElseStatement() == null) {
                body = ctIf.getThenStatement();
            } else {
                body = ctIf.getElseStatement();
                isPresentElse = true;
            }
        } else if (curStatement instanceof CtFor) {
            body = ((CtFor)curStatement).getBody();
        } else if (curStatement instanceof CtWhile) {
            body = ((CtWhile)curStatement).getBody();
        } else {
            return;
        }
        this.impl(curStatement, nextStatement, prevStatement, body, isPresentElse);
    }

    private void goThroughList(List<CtStatement> statements, CtStatement lastStatement) {
        CtStatement prevStatement = null;
        for (int i = 0; i < statements.size() - 1; ++i) {
            CtStatement statement = statements.get(i);
            CtStatement nextStatement = statements.get(i + 1);
            if (nextStatement instanceof CtReturn && lastStatement == nextStatement) {
                return;
            }
            this.prepare(statement, nextStatement, prevStatement);
            prevStatement = statement;
        }
    }

    public <R> void visitCtBlock(CtBlock<R> block) {
        List statements = block.getStatements();
        if (block.getStatements().size() < 2) {
            return;
        }
        this.goThroughList(statements, block.getLastStatement());
    }

    public <S> void visitCtSwitch(CtSwitch<S> switchStatement) {
        for (CtCase ctCase : switchStatement.getCases()) {
            List statements = ctCase.getStatements();
            if (ctCase.getStatements().size() < 2) continue;
            this.goThroughList(statements, ctCase.getLastStatement());
        }
    }
}

