/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.declaration.CtElement;

public class V6038
extends PvsStudioRule {
    private final PvsStudioRule.Pattern doubleRule = new PvsStudioRule.PatternBuilder(this).setMessage("Comparison with 'Double.NaN' is meaningless. Use 'Double.isNaN()' method instead.").setSastId("CERT-NUM07-J").build();
    private final PvsStudioRule.Pattern floatRule = new PvsStudioRule.PatternBuilder(this).setMessage("Comparison with 'Float.NaN' is meaningless. Use 'Float.isNaN()' method instead.").setSastId("CERT-NUM07-J").build();

    private void apply(CtBinaryOperator<?> operator, CtExpression<?> expression) {
        int cwe;
        if (!(expression instanceof CtFieldAccess)) {
            return;
        }
        CtFieldAccess field = (CtFieldAccess)expression;
        if (!field.getVariable().getSimpleName().equals("NaN")) {
            return;
        }
        String type = RulesUtils.getTypeName(expression);
        int n = cwe = operator.getKind() == BinaryOperatorKind.NE ? 571 : 570;
        if (type.equals("double")) {
            this.doubleRule.add((CtElement)operator, new Object[0]).setCwe(cwe);
        } else if (type.equals("float")) {
            this.floatRule.add((CtElement)operator, new Object[0]).setCwe(cwe);
        }
    }

    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        if (operator.getKind() != BinaryOperatorKind.LE && operator.getKind() != BinaryOperatorKind.LT && operator.getKind() != BinaryOperatorKind.NE && operator.getKind() != BinaryOperatorKind.EQ && operator.getKind() != BinaryOperatorKind.GE && operator.getKind() != BinaryOperatorKind.GT) {
            return;
        }
        this.apply(operator, operator.getLeftHandOperand());
        this.apply(operator, operator.getRightHandOperand());
    }
}

