/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.Lazy;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import java.util.List;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtCFlowBreak;
import spoon.reflect.code.CtContinue;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtLoop;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtWhile;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6037
extends PvsStudioRule {
    private final PvsStudioRule.PatternBuilder ruleBuilder = new PvsStudioRule.PatternBuilder().setCwe(670).setSastId("CERT-MSC57-J");
    private final PvsStudioRule.Pattern breakRule = this.ruleBuilder.setMessage("An unconditional 'break' within a loop.").build();
    private final PvsStudioRule.Pattern continueRule = this.ruleBuilder.setMessage("An unconditional 'continue' within a loop.").build();
    private final PvsStudioRule.Pattern returnRule = this.ruleBuilder.setMessage("An unconditional 'return' within a loop.").build();
    private final PvsStudioRule.Pattern throwRule = this.ruleBuilder.setMessage("An unconditional 'throw' within a loop.").build();

    private void add(CtElement pos) {
        if (pos instanceof CtBreak) {
            this.breakRule.add(pos, new Object[0]);
        } else if (pos instanceof CtContinue) {
            this.continueRule.add(pos, new Object[0]);
        } else if (pos instanceof CtReturn) {
            this.returnRule.add(pos, new Object[0]);
        } else if (pos instanceof CtThrow) {
            this.throwRule.add(pos, new Object[0]);
        } else assert (false);
    }

    private boolean isOneReturnStatement(List<CtStatement> statements, CtForEach foreach) {
        return statements.size() == 1 && statements.get(0) instanceof CtReturn && this.containsVariableReference((CtElement)((CtReturn)statements.get(0)).getReturnedExpression(), foreach.getVariable().getReference());
    }

    private boolean isOneStatementWithBreak(List<CtStatement> statements, CtForEach foreach) {
        return statements.size() == 2 && statements.get(1) instanceof CtBreak && !(statements.get(0) instanceof CtIf) && !(statements.get(0) instanceof CtSwitch) && !(statements.get(0) instanceof CtTry) && this.containsVariableReference((CtElement)statements.get(0), foreach.getVariable().getReference());
    }

    private boolean containsVariableReference(CtElement element, CtLocalVariableReference<?> variableReference) {
        return !element.getElements(el -> el.equals((Object)variableReference)).isEmpty();
    }

    private boolean isExceptionPrepareFirstElement(CtForEach foreach) {
        if (!(foreach.getBody() instanceof CtBlock)) {
            return false;
        }
        List statements = ((CtBlock)foreach.getBody()).getStatements();
        if (statements.size() == 2) {
            if (this.isOneStatementWithBreak(statements, foreach)) {
                return true;
            }
            return statements.get(1) instanceof CtBreak && statements.get(0) instanceof CtTry && ((CtTry)statements.get(0)).getBody().getStatements().size() == 1 && this.containsVariableReference((CtElement)((CtTry)statements.get(0)).getBody().getLastStatement(), foreach.getVariable().getReference());
        }
        if (statements.size() == 1) {
            CtBlock bodyFinal;
            if (this.isOneReturnStatement(statements, foreach)) {
                return true;
            }
            if (statements.get(0) instanceof CtTry && (this.isOneReturnStatement(((CtTry)statements.get(0)).getBody().getStatements(), foreach) || this.isOneStatementWithBreak(((CtTry)statements.get(0)).getBody().getStatements(), foreach))) {
                return true;
            }
            if (statements.get(0) instanceof CtTry && ((CtTry)statements.get(0)).getBody().getStatements().size() == 1 && this.containsVariableReference((CtElement)((CtTry)statements.get(0)).getBody().getLastStatement(), foreach.getVariable().getReference()) && (bodyFinal = ((CtTry)statements.get(0)).getFinalizer()) != null) {
                return bodyFinal.getStatements().size() == 1 && bodyFinal.getLastStatement() instanceof CtBreak;
            }
        }
        return false;
    }

    @Override
    public void visitCtForEach(CtForEach foreach) {
        if (this.isExceptionPrepareFirstElement(foreach)) {
            return;
        }
        this.visitCtLoop((CtLoop)foreach);
    }

    @Override
    public void visitCtLoop(CtLoop loop) {
        if (loop.getLabel() != null) {
            return;
        }
        if (!(loop.getBody() instanceof CtBlock)) {
            return;
        }
        if (loop instanceof CtWhile && RulesUtils.isTrueLiteral(((CtWhile)loop).getLoopingExpression())) {
            return;
        }
        Lazy<Integer> firstContinue = Lazy.of(() -> loop.getBody().getElements((Filter)new TypeFilter(CtContinue.class)).stream().findFirst().map(CtElement::getPosition).map(SourcePosition::getLine).orElse(Integer.MAX_VALUE));
        ((CtBlock)loop.getBody()).getStatements().stream().filter(CtCFlowBreak.class::isInstance).filter(st -> st.getPosition().getLine() < (Integer)firstContinue.get()).findFirst().ifPresent(this::add);
    }
}

