/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.IntegerVirtualValue;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.declaration.CtElement;

public class V6034
extends PvsStudioRule {
    private final PvsStudioRule.PatternBuilder ruleBuilder = new PvsStudioRule.PatternBuilder().setLevel(WarningLevel.LEVEL_2).setCwe(758).setSastId("CERT-NUM14-J").setSecId("SEC-OVERFLOW-OR-INT-UINT");
    private final PvsStudioRule.Pattern preciseRule = this.ruleBuilder.setMessage("Shift by '%s' bits is inconsistent with the size of type.").build();
    private final PvsStudioRule.Pattern rangeRule = this.ruleBuilder.setMessage("Shift could be inconsistent with the size of type: [%2$s .. %3$s].").setExtendedMessage("Shift by the value of '%1$s' could be inconsistent with the size of type: '%1$s' = [%2$s .. %3$s].").build();

    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        long maxBits;
        if (operator.getKind() != BinaryOperatorKind.SL && operator.getKind() != BinaryOperatorKind.SR && operator.getKind() != BinaryOperatorKind.USR) {
            return;
        }
        if (this.isConstantExpression(operator.getRightHandOperand())) {
            return;
        }
        IntegerVirtualValue bits = this.getValue((CtElement)operator.getRightHandOperand()).toInteger();
        if (bits == null) {
            return;
        }
        long l = maxBits = RulesUtils.getRawTypeName(operator).equals("long") ? 64L : 32L;
        if (bits.containsPreciseFromRange(maxBits, Long.MAX_VALUE) || bits.containsPreciseFromRange(Long.MIN_VALUE, -1L)) {
            if (bits.singletonValue().isPresent()) {
                this.preciseRule.add((CtElement)operator.getRightHandOperand(), bits);
            } else {
                this.rangeRule.add((CtElement)operator.getRightHandOperand(), operator.getRightHandOperand(), bits.min(), bits.max());
            }
        }
    }
}

