/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.annotation.matcher.Matcher;
import com.pvsstudio.core.StateKeys;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtArrayWrite;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6033
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("An item with the same key '%s' has already been %s.").setCwe(462).build();
    private final Set<Matcher<CtTypeReference<?>>> multimaps = Set.of(Matcher.ofClass((String)"org.springframework.util.MultiValueMap").includeSubtypes().build());

    private boolean isPresentTarget(@NotNull CtElement element, CtExpression<?> target) {
        List expressions = element.getElements((Filter)new TypeFilter(CtExpression.class));
        ArrayList<CtExpression> allTargets = new ArrayList<CtExpression>();
        while (target != null) {
            allTargets.add(target);
            if (target instanceof CtInvocation) {
                target = ((CtInvocation)target).getTarget();
                continue;
            }
            if (!(target instanceof CtFieldAccess)) break;
            target = ((CtFieldAccess)target).getTarget();
        }
        return allTargets.stream().anyMatch(tar -> expressions.stream().anyMatch(expr -> RulesUtils.equals((CtElement)tar, (CtElement)expr)));
    }

    private boolean isPresentKey(@NotNull CtElement element, Set<CtExpression<?>> keys) {
        return element.getElements((Filter)new TypeFilter(CtExpression.class)).stream().anyMatch(arg -> keys.stream().anyMatch(key -> RulesUtils.equals((CtElement)arg, (CtElement)key)));
    }

    private boolean isPresentThis(@NotNull CtExpression<?> statement, @NotNull CtExpression<?> target) {
        if (!target.getElements((Filter)new TypeFilter(CtThisAccess.class)).isEmpty()) {
            return !statement.getElements((Filter)new TypeFilter(CtThisAccess.class)).isEmpty();
        }
        return false;
    }

    public <T> void visitCtBlock(CtBlock<T> body) {
        CtExpression target = null;
        HashSet keys = new HashSet();
        boolean isSkip = false;
        LastStatement lastStatementSkip = LastStatement.None;
        for (CtStatement statement : body.getStatements()) {
            if (statement instanceof CtInvocation) {
                CtInvocation invocation = (CtInvocation)statement;
                StateKeys stateKey = this.getMethodAnnotation((CtAbstractInvocation<?>)invocation).getStateKeys();
                if (stateKey != StateKeys.None) {
                    String op;
                    CtExpression key;
                    lastStatementSkip = LastStatement.None;
                    CtExpression currentTarget = invocation.getTarget();
                    if (target != null && !target.equals((Object)currentTarget)) {
                        target = null;
                        keys.clear();
                        isSkip = false;
                    }
                    if (stateKey == StateKeys.AdditionUnknown) continue;
                    if (stateKey == StateKeys.DeletingUnknown) {
                        keys.clear();
                        continue;
                    }
                    if (invocation.getArguments().isEmpty() || (key = (CtExpression)invocation.getArguments().get(0)) instanceof CtInvocation || key instanceof CtConstructorCall) continue;
                    if (stateKey == StateKeys.Deleting) {
                        keys.remove(key);
                        continue;
                    }
                    target = currentTarget;
                    if (keys.add(key)) continue;
                    if (stateKey != StateKeys.Modifying) {
                        CtTypeReference type = invocation.getExecutable().getDeclaringType();
                        if (type != null && this.isMultimap(type)) continue;
                        op = "added";
                    } else {
                        op = "changed";
                    }
                    keys.stream().filter(arg_0 -> ((CtExpression)key).equals(arg_0)).findFirst().ifPresent(expression -> this.rule.add((CtElement)key, key, op).addSourcePosition((CtElement)expression, this.getModule()));
                    continue;
                }
                if (target != null && (lastStatementSkip == LastStatement.Something || this.isPresentTarget((CtElement)invocation, target) || this.isPresentThis(invocation.getTarget(), target) || invocation.getExecutable().getSimpleName().contains("assert"))) {
                    target = null;
                    keys.clear();
                    isSkip = false;
                    lastStatementSkip = LastStatement.None;
                    continue;
                }
                lastStatementSkip = LastStatement.Invocation;
                continue;
            }
            if (statement instanceof CtAssignment && ((CtAssignment)statement).getAssigned() instanceof CtArrayWrite) {
                String op;
                CtExpression key;
                lastStatementSkip = LastStatement.None;
                CtAssignment ctAssignment = (CtAssignment)statement;
                if (ctAssignment instanceof CtOperatorAssignment) continue;
                CtArrayWrite assigned = (CtArrayWrite)ctAssignment.getAssigned();
                if (target != null && !target.equals((Object)assigned.getTarget())) {
                    target = null;
                    keys.clear();
                    isSkip = false;
                }
                if ((key = assigned.getIndexExpression()) instanceof CtInvocation || key instanceof CtConstructorCall || key instanceof CtBinaryOperator || key instanceof CtUnaryOperator && ((op = RulesUtils.getOperatorText(((CtUnaryOperator)key).getKind())).equals("++") || op.equals("--"))) continue;
                if (this.isPresentTarget((CtElement)ctAssignment.getAssignment(), target)) {
                    target = null;
                    keys.clear();
                    isSkip = false;
                    continue;
                }
                target = assigned.getTarget();
                if (keys.add(key)) continue;
                keys.stream().filter(arg_0 -> ((CtExpression)key).equals(arg_0)).findFirst().ifPresent(expression -> this.rule.add((CtElement)key, key, "changed").addSourcePosition((CtElement)expression, this.getModule()));
                continue;
            }
            if (target == null) continue;
            if (isSkip || lastStatementSkip == LastStatement.Invocation || this.isPresentTarget((CtElement)statement, target) || this.isPresentKey((CtElement)statement, keys)) {
                target = null;
                keys.clear();
                isSkip = false;
                lastStatementSkip = LastStatement.None;
                continue;
            }
            isSkip = true;
            lastStatementSkip = LastStatement.Something;
        }
    }

    private void analyzeSetExpression(CtExpression<?> expression) {
        List interestingInvocations = expression.getElements(inv -> inv.getTarget() != null && (inv.getTarget().toString().endsWith("Arrays") && inv.getExecutable().getSimpleName().contains("asList") || inv.getTarget().toString().endsWith("Stream") && inv.getExecutable().getSimpleName().equals("of") || inv.getTarget().toString().endsWith("ImmutableSet") && inv.getExecutable().getSimpleName().equals("of") || inv.getTarget().toString().endsWith("Sets") && inv.getExecutable().getSimpleName().startsWith("new") && inv.getExecutable().getSimpleName().endsWith("Set")));
        for (CtInvocation invocation : interestingInvocations) {
            HashSet<CtExpression> keys = new HashSet<CtExpression>();
            List listArgs = invocation.getArguments();
            for (CtExpression arg : listArgs) {
                CtTypeReference type;
                if (arg instanceof CtInvocation || arg instanceof CtConstructorCall || keys.add(arg) || (type = invocation.getExecutable().getDeclaringType()) != null && this.isMultimap(type)) continue;
                keys.stream().filter(arg_0 -> ((CtExpression)arg).equals(arg_0)).findFirst().ifPresent(expr -> this.rule.add((CtElement)arg, arg, "added").addSourcePosition((CtElement)expr, this.getModule()));
            }
        }
    }

    public <T> void visitCtLocalVariable(CtLocalVariable<T> variable) {
        CtTypeReference type = variable.getType();
        if (type == null || variable.getDefaultExpression() == null) {
            return;
        }
        String simpleNameType = type.getSimpleName();
        if (simpleNameType.endsWith("Set")) {
            this.analyzeSetExpression(variable.getDefaultExpression());
        } else if (simpleNameType.endsWith("Map")) {
            // empty if block
        }
    }

    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> assignment) {
        CtTypeReference type = assignment.getAssigned().getType();
        if (type == null) {
            return;
        }
        String simpleNameType = type.getSimpleName();
        if (simpleNameType.endsWith("Set")) {
            this.analyzeSetExpression(assignment.getAssignment());
        } else if (simpleNameType.endsWith("Map")) {
            // empty if block
        }
    }

    private boolean isMultimap(CtTypeReference<?> type) {
        return this.multimaps.stream().anyMatch(matcher -> matcher.matches((CtElement)type));
    }

    private static enum LastStatement {
        None,
        Invocation,
        Something;

    }
}

