/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.google.common.collect.ImmutableSet;
import com.pvsstudio.rules.Equality;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import spoon.reflect.code.CtAssert;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtThrow;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;

public class V6032
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("It is odd that the body of method is fully equivalent to the body of another method.").setExtendedMessage("It is odd that the body of method '%s' is fully equivalent to the body of another method '%s'.").setLevel(WarningLevel.LEVEL_2).build();
    private static final String[][] EXCLUDE_PAIRS = new String[][]{{"count", "size", "length"}};
    private static final String[][] ANTAGONISTS = new String[][]{{"x", "y", "z"}, {"u", "v"}, {"dx", "dy", "dz"}, {"left", "right"}, {"up", "down", "left", "right", "top", "bottom", "height", "width", "depth", "x", "y"}, {"push", "pop"}, {"delete", "insert"}, {"remove", "add", "sub"}, {"remove", "add", "subtract"}, {"min", "max"}, {"mul", "div"}, {"hi", "lo"}, {"high", "low"}, {"begin", "end"}, {"start", "finish", "stop"}, {"open", "close"}, {"read", "write"}, {"reader", "writer"}, {"get", "set"}, {"first", "second", "last"}, {"yes", "no"}, {"from", "to"}, {"save", "cancel", "apply", "ok"}, {"next", "prev"}, {"next", "previous"}, {"lock", "unlock"}, {"lower", "upper"}, {"create", "destroy"}, {"increment", "decrement"}, {"old", "new"}, {"show", "hide"}, {"suspend", "resume", "pause"}, {"minus", "plus"}, {"0", "1", "2"}};
    private static final Set<String> EXCLUDE_NAMES = ImmutableSet.of((Object)"zero", (Object)"empty", (Object)"toString", (Object)"hashCode");
    private static final List<String> REMOVE_PREFIXES = Arrays.asList("is", "get", "set");

    public <T> void visitCtClass(CtClass<T> ctClass) {
        IdentityHashMap duplicates = new IdentityHashMap();
        ((StreamEx)((StreamEx)((StreamEx)((StreamEx)((StreamEx)((StreamEx)StreamEx.ofPairs(this.getClassMethods(ctClass), Pair::new).filter(p -> !V6032.containsNamePair(p.leftName, p.rightName, EXCLUDE_PAIRS))).filter(p -> !this.getMethodName(p.left).equals(this.getMethodName(p.right)))).filter(this::areMethodsEquals)).filter(p -> p.areAntagonists || !this.isVirtual(p.left) && !this.isVirtual(p.right))).filter(p -> this.count(duplicates, (Pair)p))).filter(p -> (Integer)duplicates.get(p.left) + (Integer)duplicates.get(p.right) == 2)).forEach(this::add);
    }

    private <T> List<CtMethod<?>> getClassMethods(CtClass<T> ctClass) {
        List methodsToMethodsBodies = ctClass.getTypeMembers().stream().filter(CtMethod.class::isInstance).map(m -> (CtMethod)m).map(m -> new MethodWithMethodBody((CtMethod<?>)m, (CtBlock<?>)m.getBody())).collect(Collectors.toList());
        return methodsToMethodsBodies.stream().filter(m -> m.body != null).filter(m -> !m.body.getStatements().isEmpty()).filter(m -> !this.isReturnLiteralOrThis(m.body)).filter(m -> !this.isAssertBody(m.body)).filter(m -> !this.isThrowBody(m.body)).filter(m -> !this.isCallingAnotherMethod(m.body)).filter(m -> !EXCLUDE_NAMES.contains(this.getMethodName(m.method))).filter(m -> !RulesUtils.isAnnotated(m.method, "java.lang.Deprecated")).map(m -> m.method).collect(Collectors.toList());
    }

    private boolean count(Map<CtMethod<?>, Integer> duplicates, Pair pair) {
        boolean l = duplicates.compute(pair.left, (m, old) -> old == null ? 1 : old + 1) <= 1;
        boolean r = duplicates.compute(pair.right, (m, old) -> old == null ? 1 : old + 1) <= 1;
        return l && r;
    }

    private void add(Pair p) {
        this.rule.add((CtElement)p.left, p.left.getSimpleName(), p.right.getSimpleName()).addSourcePosition((CtElement)p.right, this.getModule()).setLevel(p.areAntagonists ? this.rule.getLevel().increase() : (p.haveSimilarNames ? this.rule.getLevel() : this.rule.getLevel().decrease()));
    }

    private String getMethodName(CtMethod<?> method) {
        String name = method.getSimpleName();
        return REMOVE_PREFIXES.stream().filter(prefix -> name.length() > prefix.length()).filter(name::startsWith).filter(prefix -> Character.isUpperCase(name.charAt(prefix.length()))).map(prefix -> Character.toLowerCase(name.charAt(prefix.length())) + name.substring(prefix.length() + 1)).findFirst().orElse(name);
    }

    private boolean isVirtual(CtMethod<?> method) {
        return !method.isPrivate() && !method.isStatic() && !method.isFinal();
    }

    private static boolean containsNamePair(List<String> first, List<String> second, String[][] lists) {
        for (String[] names : lists) {
            boolean matchedFirst = false;
            boolean matchedSecond = false;
            assert (names.length >= 2);
            for (String name : names) {
                boolean firstContains = first.stream().anyMatch(name::equalsIgnoreCase);
                boolean secondContains = second.stream().anyMatch(name::equalsIgnoreCase);
                matchedFirst = matchedFirst || firstContains && !secondContains;
                boolean bl = matchedSecond = matchedSecond || !firstContains && secondContains;
                if (!matchedFirst || !matchedSecond) continue;
                return true;
            }
        }
        return false;
    }

    boolean isReturnLiteralOrThis(CtBlock<?> block) {
        if (block.getStatements().size() != 1) {
            return false;
        }
        CtStatement singleStatement = block.getStatement(0);
        if (!(singleStatement instanceof CtReturn)) {
            return false;
        }
        CtExpression returned = ((CtReturn)singleStatement).getReturnedExpression();
        return this.isConstantExpression(returned) || returned instanceof CtThisAccess;
    }

    boolean isThrowBody(CtBlock<?> block) {
        return block.getStatements().size() == 1 && block.getStatement(0) instanceof CtThrow;
    }

    boolean isAssertBody(CtBlock<?> block) {
        return block.getStatements().size() == 1 && block.getStatement(0) instanceof CtAssert;
    }

    boolean isCallingAnotherMethod(CtBlock<?> block) {
        if (block.getStatements().size() != 1) {
            return false;
        }
        CtStatement singleStatement = block.getStatement(0);
        if (singleStatement instanceof CtReturn) {
            return ((CtReturn)singleStatement).getReturnedExpression() instanceof CtInvocation;
        }
        return singleStatement instanceof CtInvocation;
    }

    private boolean areMethodsEquals(Pair p) {
        return p.left.getAnnotations().equals(p.right.getAnnotations()) && RulesUtils.equals((CtElement)p.left.getBody(), (CtElement)p.right.getBody(), Equality.INC_OR_DEC, Equality.ASSIGN);
    }

    private static class Pair {
        public final CtMethod<?> left;
        public final CtMethod<?> right;
        public final List<String> leftName;
        public final List<String> rightName;
        public final boolean areAntagonists;
        public final boolean haveSimilarNames;

        Pair(CtMethod<?> l, CtMethod<?> r) {
            this.left = l;
            this.right = r;
            this.leftName = RulesUtils.splitName(this.left.getSimpleName());
            this.rightName = RulesUtils.splitName(this.right.getSimpleName());
            this.areAntagonists = V6032.containsNamePair(this.leftName, this.rightName, ANTAGONISTS);
            this.haveSimilarNames = this.oneWordDiffers() || this.areGettersOrSetters();
        }

        private boolean areGettersOrSetters() {
            return this.leftName.size() > 1 && this.rightName.size() > 1 && this.leftName.get(0).equals(this.rightName.get(0)) && REMOVE_PREFIXES.contains(this.leftName.get(0));
        }

        private boolean oneWordDiffers() {
            return this.leftName.size() == this.rightName.size() && this.leftName.size() > 1 && StreamEx.of(this.leftName).zipWith(this.rightName.stream()).filterKeyValue((a, b) -> !a.equalsIgnoreCase((String)b)).count() == 1L;
        }
    }

    private static class MethodWithMethodBody {
        private final CtMethod<?> method;
        private final CtBlock<?> body;

        MethodWithMethodBody(CtMethod<?> method, CtBlock<?> body) {
            this.method = method;
            this.body = body;
        }
    }
}

