/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtCFlowBreak;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtLoop;
import spoon.reflect.declaration.CtElement;

public class V6031
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("The variable is being used for this loop and for the outer loop.").setExtendedMessage("The variable '%s' is being used for this loop and for the outer loop.").setLevel(WarningLevel.LEVEL_2).setCwe(691).setSastId("CERT-MSC57-J").build();
    private final PvsStudioRule.MethodInformation<Map<String, List<CtFor>>> counters = new PvsStudioRule.MethodInformation<Map>(this, HashMap::new);

    private boolean isNotInBreakOrReturnBlock(@NotNull CtElement loop) {
        for (CtElement parent = loop.getParent(); parent != null && !(parent instanceof CtLoop); parent = parent.getParent()) {
            List statements;
            if (!(parent instanceof CtBlock) || (statements = ((CtBlock)parent).getStatements()).isEmpty() || !(statements.get(statements.size() - 1) instanceof CtCFlowBreak)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void visitCtFor(CtFor forLoop) {
        if (forLoop.getBody() == null) {
            return;
        }
        String counter = RulesUtils.getSingleLoopCounter(forLoop);
        if (counter == null) {
            return;
        }
        List loops = this.counters.current().computeIfAbsent(counter, c -> new ArrayList());
        loops.add(forLoop);
        if (loops.size() < 2) {
            return;
        }
        forLoop.getBody().getElements(e -> loops.stream().anyMatch(l -> l == e)).stream().filter(this::isNotInBreakOrReturnBlock).forEach(loop -> this.rule.add((CtElement)loop, counter).addSourcePosition((CtElement)forLoop, this.getModule()));
    }
}

