/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtElement;

public class V6030
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("The '%s' method located to the right of the operator '%s' will be called regardless of the value of the left operand. Perhaps, it is better to use '%s'.").setExtendedMessage("The method located to the right of the '%2$s' operator will be called regardless of the value of the left operand. Perhaps, it is better to use '%3$s'.").setLevel(WarningLevel.LEVEL_2).setCwe(691).build();

    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        BinaryOperatorKind kind = operator.getKind();
        if (kind != BinaryOperatorKind.BITOR && kind != BinaryOperatorKind.BITAND) {
            return;
        }
        CtExpression rhs = operator.getRightHandOperand();
        if (rhs instanceof CtInvocation) {
            CtInvocation invocation = (CtInvocation)rhs;
            if (!RulesUtils.isBooleanOrBoxed(invocation)) {
                return;
            }
            String op = kind == BinaryOperatorKind.BITOR ? "|" : "&";
            String repl = kind == BinaryOperatorKind.BITOR ? "||" : "&&";
            this.rule.add((CtElement)rhs, rhs, op, repl);
        }
    }
}

