/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;

public class V6029
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("Possible incorrect order of arguments passed to method.").setExtendedMessage("Possible incorrect order of arguments passed to method: '%s', '%s'.").setLevel(WarningLevel.LEVEL_2).setCwe(683).build();
    private static final String[] IGNORED_PARAMETERS = new String[]{"Start", "Begin", "End"};
    private static final String[] IGNORED_METHODS = new String[]{"Equal", "Some", "Compare", "Sum", "Less", "Greater", "Cross", "Dot", "Swap", "Exchange", "Inverse", "Invert", "Min", "Max", "Compatible", "Format"};
    private static final String[] IGNORED_CLASSES = new String[]{"Reverse", "Transpose"};
    private final PvsStudioRule.MethodInformation<Set<CtExecutable<?>>> normalInvocations = new PvsStudioRule.MethodInformation<Set>(HashSet::new);

    private String excludeParameter(String name) {
        if (Stream.of(IGNORED_PARAMETERS).anyMatch(e -> name.contains((CharSequence)e) || name.toLowerCase().startsWith(e.toLowerCase()))) {
            return null;
        }
        return name;
    }

    @Nullable
    private String getExpressionName(CtExpression<?> expression) {
        if (expression instanceof CtVariableAccess) {
            return ((CtVariableAccess)expression).getVariable().getSimpleName();
        }
        return null;
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        if (invocation.getArguments().size() < 2 || invocation.getExecutable() == null || this.getCurrentMethod() == null) {
            return;
        }
        CtExecutable executable = invocation.getExecutable().getDeclaration();
        if (executable == null) {
            return;
        }
        if (Stream.of(IGNORED_METHODS).anyMatch(executable.getSimpleName()::contains) || this.isIgnoredClass(executable) || this.isIgnoredClass(this.getCurrentMethod())) {
            return;
        }
        List parameters = Optional.of(executable).map(CtExecutable::getParameters).orElse(Collections.emptyList()).stream().map(CtNamedElement::getSimpleName).map(this::excludeParameter).collect(Collectors.toList());
        List arguments = invocation.getArguments().stream().map(this::getExpressionName).collect(Collectors.toList());
        if (parameters.size() != invocation.getArguments().size()) {
            return;
        }
        ArrayList<ImmutablePair> misplacedArgs = new ArrayList<ImmutablePair>();
        int n = parameters.size();
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (i == j) continue;
                String formal = (String)parameters.get(i);
                String actual = (String)arguments.get(j);
                if (formal == null || !formal.equals(actual)) continue;
                String formal2 = (String)parameters.get(j);
                String actual2 = (String)arguments.get(i);
                if (formal2 == null || !formal2.equals(actual2)) continue;
                misplacedArgs.add(new ImmutablePair((Object)i, (Object)j));
            }
        }
        if (misplacedArgs.size() != 1) {
            if (misplacedArgs.isEmpty()) {
                this.normalInvocations.current().add(executable);
            }
            return;
        }
        if (this.normalInvocations.current().contains(executable)) {
            return;
        }
        CtExpression first = (CtExpression)invocation.getArguments().get((Integer)((Pair)misplacedArgs.get(0)).getLeft());
        CtExpression second = (CtExpression)invocation.getArguments().get((Integer)((Pair)misplacedArgs.get(0)).getRight());
        if (this.getType(first) != this.getType(second)) {
            return;
        }
        this.rule.add((CtElement)first, first, second).addSourcePosition((CtElement)second, this.getModule());
    }

    private boolean isIgnoredClass(@Nullable CtExecutable<?> executable) {
        return Optional.ofNullable(executable).filter(CtMethod.class::isInstance).map(CtExecutable::getReference).map(CtExecutableReference::getDeclaringType).map(CtTypeReference::getSimpleName).map(name -> Stream.of(IGNORED_CLASSES).anyMatch(name::contains)).orElse(false);
    }
}

