/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.Equality;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtArrayRead;
import spoon.reflect.code.CtArrayWrite;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.visitor.EarlyTerminatingScanner;

public class V6028
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("Identical expression to the left and to the right of compound assignment.").setExtendedMessage("Identical expression '%s' to the left and to the right of compound assignment.").build();

    public <T, A extends T> void visitCtOperatorAssignment(CtOperatorAssignment<T, A> assignment) {
        switch (assignment.getKind()) {
            case BITOR: 
            case BITAND: 
            case BITXOR: 
            case SL: 
            case SR: 
            case USR: {
                return;
            }
        }
        Visitor visitor = new Visitor(assignment);
        visitor.scan((CtElement)assignment.getAssignment());
        if (visitor.getResult() == null) {
            return;
        }
        WarningLevel level = this.rule.getLevel();
        if (visitor.getResult() == assignment.getAssignment()) {
            if (assignment.getKind() == BinaryOperatorKind.MUL) {
                return;
            }
            level = level.decrease();
        }
        this.rule.add((CtElement)visitor.getResult(), visitor.getResult()).setLevel(level);
    }

    private static class Visitor
    extends EarlyTerminatingScanner<CtExpression<?>> {
        private final CtExpression<?> needle;
        private final BinaryOperatorKind kind;

        Visitor(@NotNull CtOperatorAssignment<?, ?> assignment) {
            this.needle = assignment.getAssigned();
            this.kind = assignment.getKind();
        }

        private void check(CtExpression<?> exp) {
            if (RulesUtils.equals(this.needle, exp, Equality.IGNORE_CASTS, new Equality[0])) {
                this.setResult(exp);
                this.terminate();
            }
        }

        public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
            if (!(operator.getKind() == this.kind || operator.getKind() == BinaryOperatorKind.PLUS && this.kind == BinaryOperatorKind.MINUS || operator.getKind() == BinaryOperatorKind.MINUS && this.kind == BinaryOperatorKind.PLUS || operator.getKind() == BinaryOperatorKind.MUL && this.kind == BinaryOperatorKind.DIV || operator.getKind() == BinaryOperatorKind.DIV && this.kind == BinaryOperatorKind.MUL)) {
                return;
            }
            super.visitCtBinaryOperator(operator);
        }

        public <T> void visitCtVariableRead(CtVariableRead<T> variableRead) {
            this.check((CtExpression<?>)variableRead);
            super.visitCtVariableRead(variableRead);
        }

        public <T> void visitCtVariableWrite(CtVariableWrite<T> variableWrite) {
            this.check((CtExpression<?>)variableWrite);
            super.visitCtVariableWrite(variableWrite);
        }

        public <T> void visitCtArrayRead(CtArrayRead<T> arrayRead) {
            this.check((CtExpression<?>)arrayRead);
            super.visitCtArrayRead(arrayRead);
        }

        public <T> void visitCtArrayWrite(CtArrayWrite<T> arrayWrite) {
            this.check((CtExpression<?>)arrayWrite);
            super.visitCtArrayWrite(arrayWrite);
        }

        public <T> void visitCtFieldRead(CtFieldRead<T> fieldRead) {
            this.check((CtExpression<?>)fieldRead);
            super.visitCtFieldRead(fieldRead);
        }

        public <T> void visitCtFieldWrite(CtFieldWrite<T> fieldWrite) {
            this.check((CtExpression<?>)fieldWrite);
            super.visitCtFieldWrite(fieldWrite);
        }

        public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        }

        public <T> void visitCtNewArray(CtNewArray<T> newArray) {
        }

        public <T> void visitCtNewClass(CtNewClass<T> newClass) {
        }
    }
}

