/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.BasicAnnotation;
import com.pvsstudio.core.Equality;
import com.pvsstudio.core.Value;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtRHSReceiver;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.visitor.EarlyTerminatingScanner;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6027
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("Variables are initialized through the call to the same function. It's probably an error or un-optimized code.").setExtendedMessage("Variables '%s', '%s' are initialized through the call to the same function. It's probably an error or un-optimized code.").setLevel(WarningLevel.LEVEL_3).build();

    private boolean isPureInvocations(CtExpression<?> expr) {
        return expr.getElements((Filter)new TypeFilter(CtInvocation.class)).stream().map(this::getMethodAnnotation).allMatch(BasicAnnotation::getPure);
    }

    private boolean hasModifications(List<CtVariableAccess<?>> vars, List<CtVariableAccess<?>> nextVars) {
        for (CtVariableAccess<?> var : vars) {
            for (CtVariableAccess<?> nextVar : nextVars) {
                Value nextValue;
                Value value;
                if (!var.equals(nextVar) || (value = this.getValue((CtElement)var)).equals(nextValue = this.getValue((CtElement)nextVar), Equality.ByContent)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private CtElement getLhs(CtStatement statement) {
        if (statement instanceof CtAssignment) {
            return ((CtAssignment)statement).getAssigned();
        }
        if (statement instanceof CtVariable) {
            return ((CtVariable)statement).getReference();
        }
        return null;
    }

    private boolean isSameThirdStatement(List<CtStatement> statements, CtExpression<?> rhs, int i) {
        CtStatement thirdStatement = null;
        if (i < statements.size() - 2) {
            thirdStatement = statements.get(i + 2);
        } else if (i > 0) {
            thirdStatement = statements.get(i - 1);
        }
        if (thirdStatement instanceof CtRHSReceiver) {
            CtExpression thirdRhs = ((CtRHSReceiver)thirdStatement).getAssignment();
            return rhs.equals((Object)thirdRhs);
        }
        return false;
    }

    private boolean hasConstructorCall(CtExpression<?> expr) {
        EarlyTerminatingScanner<Boolean> scanner = new EarlyTerminatingScanner<Boolean>(){

            public <T> void visitCtConstructorCall(CtConstructorCall<T> ctConstructorCall) {
                this.setResult(true);
                this.terminate();
            }

            public <T> void visitCtNewArray(CtNewArray<T> newArray) {
                this.setResult(true);
                this.terminate();
            }
        };
        scanner.scan(expr);
        return scanner.getResult() != null && (Boolean)scanner.getResult() != false;
    }

    private boolean isSimple(CtExpression<?> expr) {
        final MutableInt counter = new MutableInt(0);
        int minOperands = 4;
        EarlyTerminatingScanner<Object> scanner = new EarlyTerminatingScanner<Object>(){

            private void increment() {
                counter.increment();
                if (counter.getValue() >= 4) {
                    this.terminate();
                }
            }

            public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
                this.increment();
            }

            public <T> void visitCtLiteral(CtLiteral<T> literal) {
                this.increment();
            }

            public <T> void visitCtInvocation(CtInvocation<T> invocation) {
                counter.setValue(Integer.MAX_VALUE);
                this.terminate();
            }
        };
        scanner.scan(expr);
        return counter.intValue() < 4;
    }

    public <R> void visitCtBlock(CtBlock<R> block) {
        List statements = block.getStatements();
        for (int i = 0; i < statements.size() - 1; ++i) {
            List nextVars;
            CtStatement statement = (CtStatement)statements.get(i);
            CtStatement nextStatement = (CtStatement)statements.get(i + 1);
            if (!(statement instanceof CtRHSReceiver) || !(nextStatement instanceof CtRHSReceiver) || statement instanceof CtOperatorAssignment || nextStatement instanceof CtOperatorAssignment) continue;
            CtExpression rhs = ((CtRHSReceiver)statement).getAssignment();
            CtExpression nextRhs = ((CtRHSReceiver)nextStatement).getAssignment();
            if (rhs == null || this.isSimple(rhs) || !rhs.equals((Object)nextRhs) || !this.isPureInvocations(rhs) || !this.isPureInvocations(nextRhs)) continue;
            if (this.isSameThirdStatement(statements, rhs, i) || this.hasConstructorCall(rhs)) {
                ++i;
                continue;
            }
            List vars = rhs.getElements((Filter)new TypeFilter(CtVariableAccess.class));
            if (this.hasModifications(vars, nextVars = nextRhs.getElements((Filter)new TypeFilter(CtVariableAccess.class)))) {
                ++i;
                continue;
            }
            CtElement var1 = this.getLhs(statement);
            CtElement var2 = this.getLhs(nextStatement);
            if (var1 != null && var2 != null) {
                this.rule.add((CtElement)nextRhs, var1, var2).addSourcePosition((CtElement)rhs, this.getModule());
                continue;
            }
            this.rule.add((CtElement)nextRhs, new Object[0]).addSourcePosition((CtElement)rhs, this.getModule());
        }
    }
}

