/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.Value;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import java.util.Optional;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtFor;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeInformation;
import spoon.reflect.declaration.CtVariable;

public class V6026
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("This value is already assigned to the '%s' variable.").setSastId("CERT-MSC56-J").build();

    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> assignment) {
        Value rhs;
        if (RulesUtils.isPrimitive(assignment.getAssigned()) != RulesUtils.isPrimitive(assignment.getAssignment())) {
            return;
        }
        if (assignment.getParent() instanceof CtFor) {
            return;
        }
        Value lhs = this.getValue((CtElement)assignment.getAssigned());
        if (!lhs.equals(rhs = this.getValue((CtElement)assignment.getAssignment()))) {
            return;
        }
        CtElement definition = this.getDataFlow().getExpressionByIndex(lhs.getDefinition());
        if (definition != null) {
            if (!this.checkMethodSimilarity((CtElement)assignment, definition)) {
                return;
            }
            if (definition.getParent() instanceof CtVariable && this.isConstantExpression(((CtVariable)definition.getParent()).getDefaultExpression()) && this.getDataFlow().getParentStatement((CtElement)assignment) != this.getDataFlow().getParentStatement(definition)) {
                return;
            }
        }
        this.rule.add((CtElement)assignment, assignment.getAssigned());
    }

    private boolean checkMethodSimilarity(CtElement assignment, CtElement previousAssignment) {
        CtElement assignmentExecutableType;
        CtExecutable definitionExecutable = (CtExecutable)previousAssignment.getParent(CtExecutable.class);
        if (definitionExecutable == null) {
            return false;
        }
        CtExecutable assignmentExecutable = (CtExecutable)assignment.getParent(CtExecutable.class);
        if (definitionExecutable == assignmentExecutable) {
            return true;
        }
        if (assignmentExecutable != null && !(assignmentExecutable instanceof CtAnonymousExecutable) && !(assignmentExecutable instanceof CtConstructor)) {
            return false;
        }
        CtTypeInformation definitionExecutableType = this.getType(definitionExecutable.getParent());
        CtElement ctElement = assignmentExecutableType = assignmentExecutable != null ? assignmentExecutable.getParent() : assignment.getParent(CtType.class);
        if (!(assignmentExecutableType instanceof CtType)) {
            return false;
        }
        return definitionExecutableType != null && !RulesUtils.implementsType(((CtType)assignmentExecutableType).getReference(), definitionExecutableType.getQualifiedName(), true);
    }

    private CtTypeInformation getType(CtElement element) {
        return Optional.of(element).filter(CtTypeInformation.class::isInstance).map(CtTypeInformation.class::cast).orElse(null);
    }
}

