/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.Annotation;
import com.pvsstudio.core.Constraint;
import com.pvsstudio.core.Context;
import com.pvsstudio.core.FunctionClassification;
import com.pvsstudio.core.Int128;
import com.pvsstudio.core.IntegerVirtualValue;
import com.pvsstudio.core.OptionalInt;
import com.pvsstudio.core.OptionalInt128;
import com.pvsstudio.core.Result;
import com.pvsstudio.core.Value;
import com.pvsstudio.dataflow.java.DataFlow;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtArrayRead;
import spoon.reflect.code.CtArrayWrite;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtLoop;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.EarlyTerminatingScanner;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6025
extends PvsStudioRule {
    private final PvsStudioRule.Pattern preciseValue = new PvsStudioRule.PatternBuilder().setMessage("Index is out of bounds.").setExtendedMessage("Index '%s' is out of bounds.").setSecId("SEC-BUF-OVERFLOW").build();
    private final PvsStudioRule.Pattern rangeValue = new PvsStudioRule.PatternBuilder().setMessage("Possibly index is out of bounds.").setExtendedMessage("Possibly index '%s' is out of bounds.").setSecId("SEC-BUF-OVERFLOW").build();

    private void add(CtElement invocation, CtElement index, Result res, int cweId) {
        this.add(invocation, index, RulesUtils.getLevel(res), cweId);
    }

    private void add(CtElement invocation, CtElement index, WarningLevel level, int cweId) {
        CtBlock body;
        CtExpression target;
        if (invocation instanceof CtInvocation && this.getCurrentMethod() != null && (target = ((CtInvocation)invocation).getTarget()) != null && ((body = this.getCurrentMethod().getBody()) == null || !body.filterChildren(e -> e.getExecutable().getSimpleName().equals("contains") && target.equals((Object)e.getTarget())).list().isEmpty())) {
            return;
        }
        PvsStudioRule.Pattern pattern = this.getValue(index).toLong().isPresent() ? this.preciseValue : this.rangeValue;
        pattern.add(invocation, index).setLevel(level).setCwe(cweId);
    }

    @Override
    public boolean isEnabledInFirstIteration() {
        return true;
    }

    @Override
    public void visitContractFailure(@NotNull CtAbstractInvocation<?> invocation, @NotNull Context context, @NotNull Annotation annotation, @NotNull Constraint constraint, @NotNull Stream<Map.Entry<Integer, CtElement>> usedArguments, @NotNull Result result) {
        if (constraint != Constraint.IndexOutOfBounds) {
            return;
        }
        int cweId = this.getMethodAnnotation(invocation).is(FunctionClassification.ModifiesObject) ? 787 : 125;
        usedArguments.skip(1L).findFirst().ifPresent(e -> this.add((CtElement)invocation, (CtElement)e.getValue(), result, cweId));
    }

    private void visitCtArrayAccess(CtArrayAccess<?, ?> arrayAccess, int cweId) {
        Value indexValue = this.getValue((CtElement)arrayAccess.getIndexExpression());
        Result res = this.constraints().inBounds(this.getValue((CtElement)arrayAccess.getTarget()), indexValue);
        if (res == Result.Ok) {
            WarningLevel level = this.findArrayUsingErrorByDataFlow(arrayAccess, indexValue);
            if (level != null) {
                this.add((CtElement)arrayAccess, (CtElement)arrayAccess.getIndexExpression(), level, cweId);
            }
            return;
        }
        this.add((CtElement)arrayAccess, (CtElement)arrayAccess.getIndexExpression(), res, cweId);
    }

    @Nullable
    private WarningLevel findArrayUsingErrorByDataFlow(CtArrayAccess<?, ?> arrayAccess, Value indexValue) {
        DataFlow javaDataFlow = this.getJavaDataFlow();
        IntegerVirtualValue indexVirtualValue = indexValue.toInteger();
        CtExpression index = arrayAccess.getIndexExpression();
        if (javaDataFlow == null || indexVirtualValue == null || arrayAccess.getParent(CtExecutable.class) == null || arrayAccess.getParent(CtLoop.class) != null || this.isRuleException(index) || this.isRuleExceptionInDefinitions(index, javaDataFlow)) {
            return null;
        }
        List<CtVariableAccess<?>> indexVars = this.getUsingVarsFrom((CtElement)index);
        MutableObject mutableArrayVariable = new MutableObject(null);
        int dimensionIndex = this.getDimensionIndex(arrayAccess, mutableArrayVariable);
        if (mutableArrayVariable.getValue() == null) {
            return null;
        }
        CtVariableAccess arrayVariable = (CtVariableAccess)mutableArrayVariable.getValue();
        List<CtElement> arrayDefinitions = javaDataFlow.getAllDefaultExpressions(arrayVariable);
        MutableObject errorWarningLevel = new MutableObject(null);
        for (CtElement definition : arrayDefinitions) {
            CtNewArray newArray;
            List sizeExpressions;
            if (definition instanceof CtInvocation) {
                return null;
            }
            if (!this.isValidDefaultExpression(definition, arrayVariable.getVariable()) || (sizeExpressions = (newArray = (CtNewArray)definition).getDimensionExpressions()) == null || sizeExpressions.size() <= dimensionIndex) continue;
            CtExpression sizeExpression = (CtExpression)sizeExpressions.get(dimensionIndex);
            IntegerVirtualValue integerVirtualValue = this.getValue((CtElement)sizeExpression).toInteger();
            if (this.getUsingVarsFrom((CtElement)sizeExpression).stream().anyMatch(indexVars::contains) || this.isRuleException(sizeExpression) || this.isRuleExceptionInDefinitions(sizeExpression, javaDataFlow) || integerVirtualValue == null || !integerVirtualValue.isPrecise()) {
                return null;
            }
            WarningLevel warningLevel = this.inBounds(integerVirtualValue, indexVirtualValue);
            if (warningLevel != null) {
                errorWarningLevel.setValue((Object)warningLevel);
                continue;
            }
            return null;
        }
        return (WarningLevel)((Object)errorWarningLevel.getValue());
    }

    private boolean isRuleExceptionInDefinitions(CtExpression<?> expression, DataFlow dataFlow) {
        for (CtVariableAccess<?> reference : this.getUsingVarsFrom((CtElement)expression)) {
            for (CtElement defaultExpression : dataFlow.getAllDefaultExpressions(reference)) {
                if (!(defaultExpression instanceof CtExpression) || !this.isRuleException((CtExpression)defaultExpression)) continue;
                return true;
            }
        }
        return false;
    }

    private List<CtVariableAccess<?>> getUsingVarsFrom(@Nullable CtElement element) {
        if (element == null) {
            return Collections.emptyList();
        }
        List variableAccesses = element.getElements((Filter)new TypeFilter(CtVariableAccess.class));
        return variableAccesses.stream().filter(Predicate.not(x -> x instanceof CtFieldAccess)).collect(Collectors.toList());
    }

    private boolean isValidDefaultExpression(@NotNull CtElement defaultExpression, @NotNull CtVariableReference<?> variableReference) {
        if (!(defaultExpression instanceof CtNewArray)) {
            return false;
        }
        CtElement parent = defaultExpression.getParent();
        return Optional.of(parent).filter(x -> x instanceof CtLocalVariable).map(x -> (CtLocalVariable)x).filter(x -> variableReference.equals((Object)x.getReference())).isPresent() || Optional.of(parent).filter(x -> x instanceof CtAssignment).map(x -> (CtAssignment)x).map(CtAssignment::getAssigned).filter(x -> x instanceof CtVariableAccess).map(x -> (CtVariableAccess)x).filter(x -> variableReference.equals((Object)x.getVariable())).isPresent();
    }

    private int getDimensionIndex(CtArrayAccess<?, ?> arrayAccess, MutableObject<CtVariableAccess<?>> variable) {
        int dimensionIndex = 0;
        while (arrayAccess.getTarget() instanceof CtArrayAccess) {
            ++dimensionIndex;
            arrayAccess = (CtArrayAccess)arrayAccess.getTarget();
        }
        if (arrayAccess.getTarget() instanceof CtVariableAccess) {
            variable.setValue((Object)((CtVariableAccess)arrayAccess.getTarget()));
        }
        return dimensionIndex;
    }

    private boolean isRuleException(@Nullable CtExpression<?> expression) {
        EarlyTerminatingScanner<Boolean> scanner = new EarlyTerminatingScanner<Boolean>(){

            protected void terminate() {
                this.setResult(true);
                super.terminate();
            }

            public <T> void visitCtFieldRead(CtFieldRead<T> fieldRead) {
                this.terminate();
            }

            public <T> void visitCtFieldWrite(CtFieldWrite<T> fieldWrite) {
                this.terminate();
            }

            public <T> void visitCtUnaryOperator(CtUnaryOperator<T> operator) {
                this.terminate();
            }

            public <T> void visitCtInvocation(CtInvocation<T> invocation) {
                CtExecutableReference executableReference = invocation.getExecutable();
                if (executableReference != null && executableReference.getParameters().isEmpty() && executableReference.getType() != null && executableReference.getType().getSimpleName().equals("int") && this.containsSize(executableReference.getSimpleName())) {
                    this.terminate();
                }
            }

            private boolean containsSize(String str) {
                return str.equalsIgnoreCase("size") || str.equalsIgnoreCase("length") || str.contains("Size") || str.contains("Length");
            }
        };
        scanner.scan(expression);
        return Boolean.TRUE.equals(scanner.getResult());
    }

    @Nullable
    private WarningLevel inBounds(IntegerVirtualValue size, IntegerVirtualValue index) {
        Integer indexMaxPrecise = this.getValueOrNull(index.maxPrecise());
        Integer indexMinPrecise = this.getValueOrNull(index.minPrecise());
        Integer sizeMaxPrecise = this.getValueOrNull(size.maxPrecise());
        Integer sizeMinPrecise = this.getValueOrNull(size.minPrecise());
        if (this.isMoreThenBound(sizeMaxPrecise, indexMaxPrecise) || this.isMoreThenBound(sizeMaxPrecise, indexMinPrecise)) {
            return WarningLevel.LEVEL_2;
        }
        if (this.isMoreThenBound(sizeMinPrecise, indexMaxPrecise) || this.isMoreThenBound(sizeMinPrecise, indexMinPrecise)) {
            return WarningLevel.LEVEL_3;
        }
        return null;
    }

    private boolean isMoreThenBound(@Nullable Integer bound, @Nullable Integer value) {
        return bound != null && value != null && value >= bound;
    }

    private Integer getValueOrNull(@Nullable OptionalInt128 val) {
        return Optional.ofNullable(val).filter(OptionalInt128::isPresent).map(OptionalInt128::get).map(Int128::toInt).filter(OptionalInt::isPresent).map(OptionalInt::get).orElse(null);
    }

    public <T> void visitCtArrayRead(CtArrayRead<T> arrayRead) {
        this.visitCtArrayAccess((CtArrayAccess<?, ?>)arrayRead, 125);
    }

    public <T> void visitCtArrayWrite(CtArrayWrite<T> arrayWrite) {
        this.visitCtArrayAccess((CtArrayAccess<?, ?>)arrayWrite, 787);
    }
}

