/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.annotation.SecondaryRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.List;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;

@SecondaryRule
public class V6022
extends PvsStudioRule {
    private final PvsStudioRule.Pattern methodRule = new PvsStudioRule.PatternBuilder().setMessage("Parameter is not used inside method body.").setExtendedMessage("Parameter '%s' is not used inside method body.").setLevel(WarningLevel.LEVEL_2).setSastId("CERT-MSC56-J").build();
    private final PvsStudioRule.Pattern constructorRule = new PvsStudioRule.PatternBuilder().setMessage("Parameter is not used inside constructor body.").setExtendedMessage("Parameter '%s' is not used inside constructor body.").setSastId("CERT-MSC56-J").build();
    private final PvsStudioRule.MethodInformation<Boolean> excludedMethods = new PvsStudioRule.MethodInformation();

    private boolean isExcluded(CtExecutable<?> executable) {
        if (executable != null && executable.getBody() != null) {
            List statements = executable.getBody().getStatements();
            if (statements == null || statements.isEmpty() || statements.size() == 1 && ((CtStatement)statements.get(0)).isImplicit()) {
                return true;
            }
            if (statements.get(statements.size() - 1) instanceof CtThrow) {
                return true;
            }
        }
        if (executable instanceof CtMethod) {
            CtMethod method = (CtMethod)executable;
            if (!method.isStatic() && !method.isPrivate()) {
                return true;
            }
            if (method.getSimpleName().equals("main") && method.getParameters().size() == 1) {
                return true;
            }
            return executable.getBody().getElements(e -> e instanceof CtVariableAccess || e instanceof CtConstructorCall || e instanceof CtInvocation).isEmpty();
        }
        return false;
    }

    public void apply(CtParameter<?> parameter) {
        if (this.isSuppressed("unused", "unusedArgument", "UnusedParameters", "UnusedDeclaration") || this.isSuppressed((CtElement)parameter, "unused", "unusedArgument", "UnusedParameters", "UnusedDeclaration")) {
            return;
        }
        if (this.excludedMethods.computeIfAbsent(parameter.getParent(), this::isExcluded).booleanValue()) {
            return;
        }
        if (parameter.getParent() instanceof CtMethod) {
            this.methodRule.add((CtElement)parameter, parameter.getSimpleName());
        } else if (parameter.getParent() instanceof CtConstructor) {
            this.constructorRule.add((CtElement)parameter, parameter.getSimpleName());
        }
    }
}

