/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.Lazy;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.rules.V6022;
import com.pvsstudio.rules.V6023;
import com.pvsstudio.warnings.WarningLevel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.LongStream;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtTryWithResource;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtTypeInformation;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.declaration.CtVariable;

public class V6021
extends PvsStudioRule {
    private final PvsStudioRule.PatternBuilder ruleBuilder = new PvsStudioRule.PatternBuilder().setCwe(563).setSastId("CERT-MSC56-J").setLevel(WarningLevel.LEVEL_2);
    private final PvsStudioRule.Pattern deadStore = this.ruleBuilder.setMessage("The value is assigned to the variable but is not used.").setExtendedMessage("The value is assigned to the '%s' variable but is not used.").build();
    private final PvsStudioRule.Pattern unused = this.ruleBuilder.setMessage("Variable is not used.").setExtendedMessage("Variable '%s' is not used.").build();
    private final PvsStudioRule.LinkedRule<V6022> unusedParameter = new PvsStudioRule.LinkedRule<V6022>(V6022.class);
    private final PvsStudioRule.LinkedRule<V6023> overwrittenParameter = new PvsStudioRule.LinkedRule<V6023>(V6023.class);
    private final List<CtVariable<?>> unusedVars = new ArrayList(16);

    @Override
    public void clear() {
        super.clear();
        this.unusedVars.clear();
    }

    @Override
    public boolean isEnabledInUnreachableCode() {
        return true;
    }

    public boolean isUnusedName(String name) {
        return name.startsWith("unused") || name.startsWith("ignore") || name.startsWith("tmp") || name.startsWith("_");
    }

    private String getVariableName(CtElement e) {
        return e instanceof CtVariable ? ((CtVariable)e).getSimpleName() : e.toString();
    }

    private CtElement getTarget(CtElement e) {
        if (e.getParent() instanceof CtVariable) {
            return e.getParent();
        }
        if (e.getParent() instanceof CtAssignment) {
            return ((CtAssignment)e.getParent()).getAssigned();
        }
        return e;
    }

    public <T> void visitCtParameter(CtParameter<T> localVariable) {
        this.unusedVars.add((CtVariable<?>)localVariable);
    }

    public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
        this.unusedVars.add((CtVariable<?>)localVariable);
    }

    public <T> void visitCtVariableRead(CtVariableRead<T> variable) {
        CtVariable<?> decl = this.getDeclaration(variable.getVariable());
        this.unusedVars.removeIf(v -> v == decl);
    }

    public <T> void visitCtVariableWrite(CtVariableWrite<T> variable) {
        CtVariable<?> decl = this.getDeclaration(variable.getVariable());
        this.unusedVars.removeIf(v -> v == decl);
    }

    private void add(@NotNull CtElement e) {
        if (e instanceof CtParameter) {
            if (this.unusedVars.stream().anyMatch(v -> e == v)) {
                this.unusedParameter.get().apply((CtParameter)e);
            } else {
                this.overwrittenParameter.get().apply((CtParameter)e);
            }
        } else if (e instanceof CtVariable && this.unusedVars.stream().anyMatch(v -> e == v)) {
            WarningLevel level = this.unused.getLevel();
            if (e.getParent() instanceof CtTryWithResource) {
                if (this.isSuppressed("try")) {
                    return;
                }
                level = WarningLevel.LEVEL_3;
            } else if (((CtVariable)e).getDefaultExpression() instanceof CtLiteral) {
                level = WarningLevel.LEVEL_3;
            }
            if (this.isSuppressed("unused", "UnusedDeclaration") || this.isSuppressed(e, "unused", "UnusedDeclaration")) {
                return;
            }
            CtVariable variable = (CtVariable)e;
            if (variable.getAnnotations().stream().anyMatch(annotation -> annotation.getAnnotationType().getQualifiedName().equals("lombok.Cleanup"))) {
                return;
            }
            this.unused.add(e, this.getVariableName(e)).setLevel(level);
        } else {
            WarningLevel level = this.deadStore.getLevel();
            if (e instanceof CtVariable && ((CtVariable)e).getDefaultExpression() instanceof CtLiteral) {
                level = WarningLevel.LEVEL_3;
            }
            this.deadStore.add(e, this.getVariableName(e)).setLevel(level);
        }
    }

    boolean isInDeprecatedOrTestCode(CtElement body) {
        if (this.isInsideTestSources(body)) {
            return true;
        }
        return this.getAnalyzer().getAnnotations().stream().map(CtTypedElement::getType).map(CtTypeInformation::getQualifiedName).anyMatch(name -> name.equals("java.lang.Deprecated"));
    }

    public <T> void visitCtBlock(CtBlock<T> body) {
        if (!(body.getParent() instanceof CtExecutable)) {
            return;
        }
        Lazy<Boolean> isException = Lazy.of(() -> this.isInDeprecatedOrTestCode((CtElement)body));
        long[] deadStores = this.getDataFlow().getDeadStores();
        if (deadStores != null) {
            if (isException.get().booleanValue()) {
                return;
            }
            LongStream.of(deadStores).mapToObj(this.getDataFlow()::getExpressionByIndex).filter(Objects::nonNull).filter(e -> !RulesUtils.isNullLiteral(e)).map(this::getTarget).filter(e -> !this.isUnusedName(this.getVariableName((CtElement)e))).forEach(this::add);
        }
        this.unusedVars.stream().filter(CtParameter.class::isInstance).filter(param -> param.getParent() == this.getCurrentMethod()).filter(param -> !ArrayUtils.contains((long[])deadStores, (long)this.getDataFlow().getExpressionIndex((CtElement)param))).filter(param -> (Boolean)isException.get() == false).forEach(this::add);
    }
}

