/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.google.common.collect.Range;
import com.pvsstudio.core.IntegerVirtualValue;
import com.pvsstudio.core.OptionalLong;
import com.pvsstudio.core.Value;
import com.pvsstudio.dataflow.interval.IntervalBuilder;
import com.pvsstudio.dataflow.java.DataFlow;
import com.pvsstudio.dataflow.java.UsageVisitor;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.Optional;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtLoop;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.EarlyTerminatingScanner;

public class V6020
extends PvsStudioRule {
    private final PvsStudioRule.PatternBuilder ruleBuilder = new PvsStudioRule.PatternBuilder(this).setCwe(369).setSastId("CERT-NUM02-J").setSecId("SEC-DIV-0");
    private final PvsStudioRule.Pattern rule = this.ruleBuilder.setMessage("%s by zero. Denominator '%s' == 0.").build();
    private final PvsStudioRule.Pattern ruleRange = this.ruleBuilder.setMessage("%s by zero. Denominator range ['%s'..'%s'].").build();
    private final PvsStudioRule.Pattern ruleRangeMinMax = this.ruleBuilder.setMessage("%s by zero. The range of the '%s' denominator values includes zero.").build();

    @Override
    protected boolean shouldProduceWarnings() {
        return super.shouldProduceWarnings() && !this.isSuppressed("divzero");
    }

    @Override
    public boolean isEnabledInFirstIteration() {
        return true;
    }

    private void apply(CtExpression<?> expr, boolean isMod) {
        String opText;
        if (this.isDouble(expr) && this.findErrorUsingDataFlow(expr)) {
            this.ruleRangeMinMax.add((CtElement)expr, isMod ? "Mod" : "Divide", expr).setLevel(WarningLevel.LEVEL_3);
            return;
        }
        Value value = this.getValue((CtElement)expr);
        IntegerVirtualValue integerVirtualValue = value.toInteger();
        if (integerVirtualValue == null || !integerVirtualValue.contains(0L)) {
            return;
        }
        WarningLevel level = null;
        if (!integerVirtualValue.containsPrecise(0L)) {
            if (this.isIntervalException(integerVirtualValue, expr.getType()) || this.isAstException(expr)) {
                return;
            }
            level = WarningLevel.LEVEL_3;
        }
        String string = opText = isMod ? "Mod" : "Divide";
        if (level == null) {
            WarningLevel warningLevel = level = this.isInsideTestSources((CtElement)expr) ? WarningLevel.LEVEL_3 : WarningLevel.LEVEL_1;
        }
        if (integerVirtualValue.isInterval()) {
            long min = integerVirtualValue.min().toLong().orElse(Long.MIN_VALUE);
            long max = integerVirtualValue.max().toLong().orElse(Long.MAX_VALUE);
            if (min == Long.MIN_VALUE || max == Long.MAX_VALUE || min == Integer.MIN_VALUE || max == Integer.MAX_VALUE) {
                this.ruleRangeMinMax.add((CtElement)expr, opText, expr).setLevel(level);
            } else {
                this.ruleRange.add((CtElement)expr, opText, min, max).setLevel(level);
            }
        } else if (integerVirtualValue.min().equals(0L)) {
            if (this.isZero((CtElement)expr)) {
                return;
            }
            this.rule.add((CtElement)expr, opText, expr).setLevel(level);
        }
    }

    private boolean isDouble(CtExpression<?> expression) {
        return Optional.of(expression).map(CtTypedElement::getType).map(CtTypeReference::getSimpleName).map(String::toLowerCase).filter(x -> x.equals("double") || x.equals("float")).isPresent();
    }

    private boolean findErrorUsingDataFlow(CtExpression<?> expr) {
        DataFlow dataFlow = this.getJavaDataFlow();
        CtExecutable executable = (CtExecutable)expr.getParent(CtExecutable.class);
        if (dataFlow == null || executable == null) {
            return false;
        }
        final Optional<CtVariableAccess> referenceOptional = Optional.of(expr).filter(x -> !(x instanceof CtFieldAccess)).filter(x -> x instanceof CtVariableAccess).map(x -> (CtVariableAccess)x);
        if (referenceOptional.isEmpty()) {
            return false;
        }
        MutableObject haveError = new MutableObject(null);
        UsageVisitor visitor = new UsageVisitor((Mutable)haveError, expr, dataFlow){
            private Range<Double> interval = null;
            private CtVariableReference<?> currentVariable = ((CtVariableAccess)referenceOptional.get()).getVariable();
            final /* synthetic */ Mutable val$haveError;
            final /* synthetic */ CtExpression val$expr;
            final /* synthetic */ DataFlow val$dataFlow;
            {
                this.val$haveError = mutable;
                this.val$expr = ctExpression;
                this.val$dataFlow = dataFlow;
            }

            @Override
            public void visitUsage(CtElement usage) {
                if (!this.getCurrentVariable().equals(this.currentVariable)) {
                    if (this.val$haveError.getValue() != null) {
                        this.terminateAllScan();
                        return;
                    }
                    this.currentVariable = this.getCurrentVariable();
                    this.interval = null;
                }
                if (usage instanceof CtBinaryOperator && usage.getParent() instanceof CtIf) {
                    CtBinaryOperator binaryOperator = (CtBinaryOperator)usage;
                    MutableBoolean isThenBranch = new MutableBoolean();
                    if (!this.isParentOf((CtElement)this.val$expr, (CtIf)usage.getParent(), isThenBranch)) {
                        this.interval = null;
                        this.terminateScanCurrentChain();
                        return;
                    }
                    if (V6020.this.isZero((CtElement)binaryOperator.getRightHandOperand()) || V6020.this.isZero((CtElement)binaryOperator.getLeftHandOperand())) {
                        BinaryOperatorKind kind = binaryOperator.getKind();
                        if (kind == BinaryOperatorKind.NE) {
                            if (isThenBranch.isTrue()) {
                                this.stopWithoutError();
                            } else {
                                this.processIntervals(binaryOperator, false);
                            }
                            return;
                        }
                        if (kind == BinaryOperatorKind.EQ) {
                            if (isThenBranch.isTrue()) {
                                this.processIntervals(binaryOperator, true);
                            } else {
                                this.stopWithoutError();
                            }
                            return;
                        }
                    }
                    this.processIntervals(binaryOperator, isThenBranch.getValue());
                }
            }

            @Override
            public void visitDefaultExpression(CtElement defaultExpression) {
                if (defaultExpression.getParent(CtLoop.class) != null) {
                    this.stopWithoutError();
                    return;
                }
                if (defaultExpression instanceof CtParameterReference || defaultExpression instanceof CtInvocation) {
                    if (this.interval != null && this.interval.contains((Comparable)Double.valueOf(0.0))) {
                        this.setError();
                    } else {
                        this.stopWithoutError();
                    }
                    return;
                }
                if (defaultExpression instanceof CtExpression && Optional.of(this.val$dataFlow.evaluateDouble((CtExpression)defaultExpression)).filter(v -> Math.abs(v) < Double.MIN_VALUE).isPresent()) {
                    this.setError();
                    return;
                }
                if (!(defaultExpression instanceof CtVariableAccess)) {
                    this.terminateScanCurrentChain();
                }
            }

            private boolean isParentOf(@NotNull CtElement element, @NotNull CtIf parent, @NotNull MutableBoolean thenBranchFlag) {
                while (element != null) {
                    CtElement elementParent = element.getParent();
                    if (elementParent == parent) {
                        thenBranchFlag.setValue(parent.getThenStatement() == element);
                        return true;
                    }
                    element = elementParent;
                }
                return false;
            }

            private void processIntervals(CtBinaryOperator<?> binaryOperator, boolean thenBranchFlag) {
                Range<Double> range = IntervalBuilder.generateDoubleIntervalFromAst(binaryOperator, thenBranchFlag);
                if (range == null) {
                    return;
                }
                if (this.interval == null) {
                    this.interval = range;
                } else if (this.interval.isConnected(range)) {
                    this.interval = this.interval.intersection(range);
                } else {
                    this.terminateScanCurrentChain();
                    this.interval = null;
                }
            }

            private void stopWithoutError() {
                this.val$haveError.setValue((Object)false);
                this.terminateAllScan();
            }

            private void setError() {
                if (this.val$haveError.getValue() == null) {
                    this.val$haveError.setValue((Object)true);
                }
            }
        };
        dataFlow.scanUsages((CtElement)expr, (CtVariableAccess<?>)referenceOptional.get(), visitor);
        return Boolean.TRUE.equals(haveError.getValue());
    }

    private boolean isZero(CtElement expression) {
        String stringExpression = expression.toString();
        return stringExpression.equals("0") || stringExpression.equals("0.f") || stringExpression.equals("0.0");
    }

    private boolean isIntervalException(IntegerVirtualValue value, CtTypeReference<?> typeReference) {
        long typeMax;
        long typeMin;
        String simpleName = typeReference.getSimpleName();
        OptionalLong min = value.min().toLong();
        OptionalLong max = value.max().toLong();
        if (!min.isPresent() || !max.isPresent()) {
            return true;
        }
        long minValue = min.get();
        long maxValue = max.get();
        switch (simpleName) {
            case "int": 
            case "Integer": {
                typeMin = Integer.MIN_VALUE;
                typeMax = Integer.MAX_VALUE;
                break;
            }
            case "short": 
            case "Short": {
                typeMin = -32768L;
                typeMax = 32767L;
                break;
            }
            case "byte": 
            case "Byte": {
                typeMin = -128L;
                typeMax = 127L;
                break;
            }
            case "char": 
            case "Character": {
                typeMin = 0L;
                typeMax = 65535L;
                break;
            }
            case "long": 
            case "Long": {
                typeMin = Long.MIN_VALUE;
                typeMax = Long.MAX_VALUE;
                break;
            }
            default: {
                return false;
            }
        }
        return minValue == typeMin && maxValue == typeMax - 1L || minValue == typeMin + 1L && maxValue == typeMax;
    }

    private boolean isAstException(CtExpression<?> expression) {
        if (expression.getParent(CtLoop.class) != null) {
            return true;
        }
        EarlyTerminatingScanner<Boolean> scanner = new EarlyTerminatingScanner<Boolean>(){

            public <T> void visitCtInvocation(CtInvocation<T> invocation) {
                this.setResult(true);
                this.terminate();
            }

            public <T> void visitCtLocalVariableReference(CtLocalVariableReference<T> reference) {
                CtLocalVariable variable = reference.getDeclaration();
                if (variable == null) {
                    return;
                }
                CtExpression defaultExpression = variable.getDefaultExpression();
                if (defaultExpression == null) {
                    this.setResult(true);
                    this.terminate();
                    return;
                }
                if (variable.getParent() instanceof CtFor) {
                    return;
                }
                if (V6020.this.isZero((CtElement)defaultExpression)) {
                    this.setResult(true);
                    this.terminate();
                    return;
                }
                this.scan((CtElement)variable.getDefaultExpression());
            }

            public <T> void visitCtFieldReference(CtFieldReference<T> reference) {
                this.setResult(true);
                this.terminate();
            }
        };
        scanner.scan(expression);
        return scanner.getResult() != null && (Boolean)scanner.getResult() != false;
    }

    public <T, A extends T> void visitCtOperatorAssignment(CtOperatorAssignment<T, A> operator) {
        BinaryOperatorKind opKind = operator.getKind();
        if (opKind != BinaryOperatorKind.DIV && opKind != BinaryOperatorKind.MOD) {
            return;
        }
        this.apply(operator.getAssignment(), opKind == BinaryOperatorKind.MOD);
    }

    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        BinaryOperatorKind opKind = operator.getKind();
        if (opKind != BinaryOperatorKind.DIV && opKind != BinaryOperatorKind.MOD) {
            return;
        }
        this.apply(operator.getRightHandOperand(), opKind == BinaryOperatorKind.MOD);
    }
}

