/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtCFlowBreak;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtWhile;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;

public class V6019
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("Unreachable code detected. It is possible that an error is present.").setCwe(561).build();
    private final PvsStudioRule.MethodInformation<Boolean> warnedMethods = new PvsStudioRule.MethodInformation<Boolean>(this, () -> false);

    @Override
    public boolean isEnabledInUnreachableCode() {
        return true;
    }

    @Override
    public void enter(CtElement e) {
        if (!this.getDataFlow().isUnreachable()) {
            return;
        }
        if (!(e instanceof CtStatement)) {
            return;
        }
        if (e instanceof CtBlock || e instanceof CtCase) {
            return;
        }
        if (((CtStatement)e).getLabel() != null) {
            return;
        }
        for (CtElement parent = e; parent != null && !(parent instanceof CtExecutable); parent = parent.getParent()) {
            if (this.isConstantCondition(parent)) {
                return;
            }
            if (!(parent instanceof CtCFlowBreak)) continue;
            if (parent.getParent() instanceof CtBlock && RulesUtils.endsWithFlowControl((CtStatement)((CtBlock)parent.getParent()))) {
                return;
            }
            if (!(e instanceof CtBreak) || !(parent.getParent() instanceof CtCase)) continue;
            return;
        }
        if (!this.warnedMethods.add(this.getCurrentMethod())) {
            return;
        }
        this.rule.add(e, new Object[0]);
    }

    private boolean isConstantCondition(CtElement e) {
        if (e instanceof CtConditional) {
            return !this.getValue((CtElement)((CtConditional)e).getCondition()).isIndeterminate();
        }
        if (e instanceof CtIf) {
            return !this.getValue((CtElement)((CtIf)e).getCondition()).isIndeterminate();
        }
        if (e instanceof CtFor) {
            return this.getValue((CtElement)((CtFor)e).getExpression()).isFalse();
        }
        if (e instanceof CtWhile) {
            return this.getValue((CtElement)((CtWhile)e).getLoopingExpression()).isFalse();
        }
        if (e instanceof CtDo) {
            return this.getValue((CtElement)((CtDo)e).getLoopingExpression()).isFalse();
        }
        return false;
    }
}

