/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6017
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("The 'X' counter is not used inside a nested loop. Consider inspecting usage of 'Y' counter.").setExtendedMessage("The '%s' counter is not used inside a nested loop. Consider inspecting usage of '%s' counter.").setLevel(WarningLevel.LEVEL_2).build();

    @Nullable
    private CtFor getParentLoop(CtFor loop, @NotNull MutableBoolean neighbors) {
        neighbors.setFalse();
        CtElement p = loop.getParent();
        while (p instanceof CtBlock) {
            p = p.getParent();
        }
        if (!(p instanceof CtFor)) {
            return null;
        }
        CtFor parent = (CtFor)p;
        CtStatement body = parent.getBody();
        if (body instanceof CtBlock) {
            CtBlock b;
            while ((b = (CtBlock)body).getStatements().size() == 1) {
                body = b.getStatement(0);
                if (body instanceof CtFor) {
                    neighbors.setTrue();
                    break;
                }
                if (body instanceof CtBlock) continue;
            }
        }
        return parent;
    }

    private boolean mergeCounterNames(String currentCounter, String parentCounter) {
        String trimCounter2;
        if (currentCounter.length() == 1 && parentCounter.length() == 1) {
            return true;
        }
        String trimCounter1 = currentCounter.replaceAll("\\d+$", "");
        return trimCounter1.equals(trimCounter2 = parentCounter.replaceAll("\\d+$", "")) || trimCounter1.substring(0, trimCounter1.length() - 1).equals(trimCounter2.substring(0, trimCounter2.length() - 1));
    }

    private boolean isCounterDefineLoop(CtFor loop, String counter) {
        return Stream.concat(loop.getForInit().stream(), Stream.of(loop.getExpression())).filter(Objects::nonNull).map(element -> element.getElements((Filter)new TypeFilter(CtLocalVariableReference.class))).flatMap(Collection::stream).map(CtReference::getSimpleName).anyMatch(counter::equals);
    }

    @Override
    public void visitCtFor(CtFor loopCurrent) {
        MutableBoolean areNeighbors = new MutableBoolean();
        CtFor loopParent = this.getParentLoop(loopCurrent, areNeighbors);
        if (loopParent == null) {
            return;
        }
        String currentCounter = RulesUtils.getSingleLoopCounter(loopCurrent);
        if (currentCounter == null) {
            return;
        }
        String parentCounter = RulesUtils.getSingleLoopCounter(loopParent);
        if (parentCounter == null) {
            return;
        }
        if (!this.mergeCounterNames(currentCounter, parentCounter)) {
            return;
        }
        if (this.isCounterDefineLoop(loopCurrent, parentCounter)) {
            return;
        }
        int currentInCurrent = 0;
        int parentInCurrent = 0;
        if (loopCurrent.getBody() == null) {
            return;
        }
        for (CtLocalVariableReference var : loopCurrent.getBody().getElements((Filter)new TypeFilter(CtLocalVariableReference.class))) {
            if (var.getSimpleName().equals(currentCounter)) {
                ++currentInCurrent;
            }
            if (!var.getSimpleName().equals(parentCounter)) continue;
            ++parentInCurrent;
        }
        if (currentInCurrent == 0 && parentInCurrent == 0) {
            return;
        }
        if (areNeighbors.isTrue()) {
            if (currentInCurrent == 0 && parentInCurrent >= 2) {
                this.rule.add((CtElement)loopCurrent, currentCounter, parentCounter);
            } else if (parentInCurrent == 0 && currentInCurrent >= 2) {
                this.rule.add((CtElement)loopCurrent, parentCounter, currentCounter);
            }
        } else if (currentInCurrent == 0 && parentInCurrent >= 2) {
            this.rule.add((CtElement)loopCurrent, currentCounter, parentCounter);
        }
    }
}

