/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.Lazy;
import com.pvsstudio.rules.PvsStudioRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtArrayRead;
import spoon.reflect.code.CtArrayWrite;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtWhile;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6016
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("Suspicious access to element by a constant index inside a loop.").setExtendedMessage("Suspicious access to element of '%s' object by a constant index inside a loop.").build();

    @Override
    public void visitCtFor(CtFor forLoop) {
        if (forLoop.getExpression() == null || forLoop.getBody() == null) {
            return;
        }
        if (this.isAnyCounterAbsentInForUpdateExpression(forLoop)) {
            return;
        }
        Lazy<List> elements = Lazy.of(() -> this.getTargetedExpressionsFromForExpressions(forLoop));
        List<CtTargetedExpression<?, ?>> list = this.getArrayOrCollectionAccesses(forLoop);
        list.stream().collect(Collectors.groupingBy(CtTargetedExpression::getTarget)).values().stream().filter(v -> v.size() == 1).flatMap(Collection::stream).filter(targetedExpression -> targetedExpression.getTarget() != null).filter(this::isConstantIndex).filter(targetedExpression -> ((List)elements.get()).stream().noneMatch(arg_0 -> ((CtTargetedExpression)targetedExpression).equals(arg_0))).filter(targetedExpression -> this.hasSizeAccessInForExpressions((List)elements.get(), targetedExpression.getTarget())).filter(targetedExpression -> !this.hasRemove((CtElement)forLoop.getBody(), targetedExpression.getTarget())).forEach(targetedExpression -> this.rule.add((CtElement)targetedExpression, targetedExpression.getTarget()));
    }

    private boolean isAnyCounterAbsentInForUpdateExpression(CtFor forLoop) {
        TypeFilter variableAccessTypeFilter = new TypeFilter(CtVariableAccess.class);
        List forUpdateUsedVars = forLoop.getForUpdate().stream().map(e -> e.getElements((Filter)variableAccessTypeFilter)).flatMap(Collection::stream).map(CtVariableAccess::getVariable).collect(Collectors.toList());
        TypeFilter localVariableTypeFilter = new TypeFilter(CtLocalVariable.class);
        return forLoop.getForInit().stream().map(e -> e.getElements((Filter)localVariableTypeFilter)).flatMap(Collection::stream).map(CtLocalVariable::getReference).anyMatch(v -> !forUpdateUsedVars.contains(v));
    }

    private List<CtTargetedExpression<?, ?>> getTargetedExpressionsFromForExpressions(CtFor forLoop) {
        TypeFilter filter = new TypeFilter(CtTargetedExpression.class);
        return StreamEx.empty().append((Collection)forLoop.getForUpdate()).append((Collection)forLoop.getForInit()).append((Object)forLoop.getExpression()).map(e -> e.getElements((Filter)filter)).toFlatList(Function.identity());
    }

    private List<CtTargetedExpression<?, ?>> getArrayOrCollectionAccesses(CtFor loop) {
        final ArrayList res = new ArrayList();
        CtScanner scanner = new CtScanner(){

            public <T> void visitCtInvocation(CtInvocation<T> inv) {
                super.visitCtInvocation(inv);
                if ((inv.getExecutable().getSimpleName().equals("get") || inv.getExecutable().getSimpleName().equals("set")) && !inv.getArguments().isEmpty() && inv.getTarget() != null && inv.getTarget().getType() != null && V6016.this.getTypes().isSubtypeOf(inv.getTarget(), "java.util.Collection")) {
                    res.add(inv);
                }
            }

            public <T> void visitCtArrayRead(CtArrayRead<T> arrayRead) {
                super.visitCtArrayRead(arrayRead);
                res.add(arrayRead);
            }

            public <T> void visitCtArrayWrite(CtArrayWrite<T> arrayWrite) {
                super.visitCtArrayWrite(arrayWrite);
                res.add(arrayWrite);
            }

            public void visitCtFor(CtFor forLoop) {
            }

            public void visitCtWhile(CtWhile whileLoop) {
            }

            public void visitCtDo(CtDo doLoop) {
            }

            public void visitCtForEach(CtForEach foreach) {
            }
        };
        scanner.scan((CtElement)loop.getBody());
        return res;
    }

    private boolean isConstantIndex(CtTargetedExpression<?, ?> targetedExpr) {
        if (targetedExpr instanceof CtArrayAccess) {
            CtExpression indexExpr = ((CtArrayAccess)targetedExpr).getIndexExpression();
            return this.getValue((CtElement)indexExpr).toLong().isPresent();
        }
        if (targetedExpr instanceof CtInvocation) {
            CtInvocation inv = (CtInvocation)targetedExpr;
            return this.getValue((CtElement)inv.getArguments().get(0)).toLong().isPresent();
        }
        return false;
    }

    private boolean hasRemove(CtElement element, CtExpression<?> target) {
        return !element.getElements(inv -> inv.getTarget() != null && inv.getTarget().equals((Object)target) && inv.getExecutable().getSimpleName().contains("remove")).isEmpty();
    }

    private boolean hasSizeAccessInForExpressions(List<CtTargetedExpression<?, ?>> elements, CtExpression<?> target) {
        return elements.stream().filter(this::isSizeAccess).map(CtTargetedExpression::getTarget).anyMatch(arg_0 -> target.equals(arg_0));
    }

    private boolean isSizeAccess(CtTargetedExpression<?, ?> e) {
        if (e instanceof CtInvocation) {
            return ((CtInvocation)e).getExecutable().getSimpleName().equals("size");
        }
        if (e instanceof CtFieldAccess) {
            return ((CtFieldAccess)e).getVariable().getSimpleName().equals("length");
        }
        return false;
    }
}

