/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.Optional;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtElement;

public class V6015
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("Consider inspecting the expression.").setExtendedMessage("Consider inspecting the expression. Probably the '%s' should be used here.").setLevel(WarningLevel.LEVEL_2).setCwe(480).build();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> assignment) {
        String textOp;
        CtUnaryOperator right;
        if (assignment.getAssignment() instanceof CtUnaryOperator) {
            right = (CtUnaryOperator)assignment.getAssignment();
        } else {
            if (!(assignment.getAssignment() instanceof CtBinaryOperator)) return;
            CtBinaryOperator binOp = (CtBinaryOperator)assignment.getAssignment();
            CtExpression left = binOp.getLeftHandOperand();
            while (left instanceof CtBinaryOperator) {
                left = ((CtBinaryOperator)left).getLeftHandOperand();
            }
            if (!(left instanceof CtUnaryOperator)) return;
            right = (CtUnaryOperator)left;
        }
        int posUnary = right.getPosition().getColumn() - 1;
        if (posUnary == 0) {
            return;
        }
        SourcePosition posLine = right.getPosition();
        Optional<String> firstLine = this.getModule().getLine(posLine.getFile(), posLine.getLine());
        if (firstLine.isEmpty()) {
            return;
        }
        String matchLine = "+-!";
        if (matchLine.indexOf(firstLine.get().charAt(posUnary)) == -1 || firstLine.get().charAt(posUnary - 1) != '=') {
            return;
        }
        CtExpression varWrite = assignment.getAssigned();
        switch (right.getKind()) {
            case NOT: {
                if (RulesUtils.equals((CtElement)varWrite, (CtElement)right.getOperand())) {
                    return;
                }
                textOp = "!=";
                break;
            }
            case POS: {
                textOp = "+=";
                break;
            }
            case NEG: {
                if (RulesUtils.equals((CtElement)varWrite, (CtElement)right.getOperand())) {
                    return;
                }
                if (posUnary + 1 <= firstLine.get().length() - 1 && firstLine.get().charAt(posUnary + 1) != ' ' && firstLine.get().charAt(posUnary + 1) != '\t') {
                    return;
                }
                textOp = "-=";
                break;
            }
            default: {
                return;
            }
        }
        this.rule.add((CtElement)varWrite, textOp);
    }
}

