/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.List;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtLambda;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.reference.CtTypeReference;

public class V6014
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("It's odd that this method always returns one and the same value.").setLevel(WarningLevel.LEVEL_2).setCwe(393).build();

    public <T> void visitCtBlock(CtBlock<T> body) {
        if (!(body.getParent() instanceof CtExecutable)) {
            return;
        }
        CtExecutable method = (CtExecutable)body.getParent();
        if (this.isVoidReturnType(method)) {
            return;
        }
        if (!this.getDataFlow().returnsSameValue()) {
            return;
        }
        this.rule.add((CtElement)method, new Object[0]);
    }

    private boolean isVoidReturnType(CtExecutable<?> method) {
        String voidType = "java.lang.Void";
        if (RulesUtils.getTypeName(method.getType()).equals(voidType)) {
            return true;
        }
        if (method instanceof CtLambda) {
            CtLambda lambda = (CtLambda)method;
            CtMethod overriddenMethod = lambda.getOverriddenMethod();
            if (overriddenMethod == null) {
                return false;
            }
            if (overriddenMethod.getType().getQualifiedName().equals(voidType)) {
                return true;
            }
            if (method.getType() != null && overriddenMethod.getParent() instanceof CtType) {
                List args = method.getType().getActualTypeArguments();
                CtType parent = (CtType)overriddenMethod.getParent();
                int index = 0;
                for (CtTypeParameter param : parent.getFormalCtTypeParameters()) {
                    if (overriddenMethod.getType().getSimpleName().equals(param.getSimpleName())) {
                        return args.size() > index && RulesUtils.getTypeName((CtTypeReference)args.get(index)).equals(voidType);
                    }
                    ++index;
                }
            }
        }
        return false;
    }
}

