/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.TypeClassification;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtTypeInformation;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.CtVisitor;

public class V6013
extends PvsStudioRule {
    private static final String PATTERN = " are compared by reference. Possibly an equality comparison was intended.";
    private final PvsStudioRule.PatternBuilder ruleBuilder = new PvsStudioRule.PatternBuilder(this).setCwe(595).setSastId("CERT-EXP03-J");
    private final PvsStudioRule.Pattern commonRule = this.ruleBuilder.setMessage("Objects  are compared by reference. Possibly an equality comparison was intended.").setExtendedMessage("Objects '%s' and '%s' are compared by reference. Possibly an equality comparison was intended.").build();
    private final PvsStudioRule.Pattern stringsRule = this.ruleBuilder.setMessage("Strings  are compared by reference. Possibly an equality comparison was intended.").setExtendedMessage("Strings '%s' and '%s' are compared by reference. Possibly an equality comparison was intended.").build();
    private final PvsStudioRule.Pattern arraysRule = this.ruleBuilder.setMessage("Arrays  are compared by reference. Possibly an equality comparison was intended.").setExtendedMessage("Arrays '%s' and '%s' are compared by reference. Possibly an equality comparison was intended.").build();
    private final PvsStudioRule.Pattern numbersRule = this.ruleBuilder.setMessage("Numbers  are compared by reference. Possibly an equality comparison was intended.").setExtendedMessage("Numbers '%s' and '%s' are compared by reference. Possibly an equality comparison was intended.").build();
    private final PvsStudioRule.MethodInformation<List<ComparedPair>> checked = new PvsStudioRule.MethodInformation(this);

    private List<ComparedPair> getComparedStrings(@NotNull CtExecutable<?> method) {
        final ArrayList<ComparedPair> res = new ArrayList<ComparedPair>();
        method.accept((CtVisitor)new CtScanner(){

            public <T> void visitCtInvocation(CtInvocation<T> invocation) {
                String name;
                super.visitCtInvocation(invocation);
                if (invocation.getTarget() != null && invocation.getArguments().size() == 1) {
                    String name2 = invocation.getExecutable().getSimpleName();
                    if (name2.equals("equals") || name2.equals("compareTo")) {
                        res.add(new ComparedPair((CtElement)invocation.getTarget(), (CtElement)invocation.getArguments().get(0)));
                    }
                } else if (invocation.getArguments().size() == 2 && ((name = invocation.getExecutable().getSimpleName()).equals("equals") || name.equals("compareTo"))) {
                    res.add(new ComparedPair((CtElement)invocation.getArguments().get(0), (CtElement)invocation.getArguments().get(1)));
                }
            }
        });
        return res;
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        if (!invocation.getExecutable().getSimpleName().equals("equals")) {
            return;
        }
        if (invocation.getArguments().size() == 1 && invocation.getTarget() != null && invocation.getTarget().getType() instanceof CtArrayTypeReference) {
            this.arraysRule.add((CtElement)invocation, invocation.getTarget(), invocation.getArguments().get(0));
            return;
        }
        if (invocation.getExecutable().getDeclaringType() != null && invocation.getExecutable().getDeclaringType().getQualifiedName().equals("java.util.Objects") && invocation.getArguments().size() == 2 && ((CtExpression)invocation.getArguments().get(0)).getType() instanceof CtArrayTypeReference) {
            this.arraysRule.add((CtElement)invocation, invocation.getArguments().get(0), invocation.getArguments().get(1));
        }
    }

    private boolean isExceptionObject(CtExpression<?> expression) {
        if (RulesUtils.isPrimitive(expression) || RulesUtils.isNullLiteral(expression) || expression instanceof CtThisAccess) {
            return true;
        }
        if (expression.getTypeCasts().stream().anyMatch(CtTypeInformation::isPrimitive)) {
            return true;
        }
        if (RulesUtils.getTypeName(expression).equals("java.lang.Object")) {
            return true;
        }
        if (expression instanceof CtFieldAccess) {
            CtVariable<?> var = this.getDeclaration((CtVariableReference<?>)((CtFieldAccess)expression).getVariable());
            return var != null && var.isStatic() && var.isFinal();
        }
        if (expression instanceof CtInvocation) {
            CtInvocation invocation = (CtInvocation)expression;
            return invocation.getArguments().isEmpty() && invocation.getExecutable().getSimpleName().startsWith("empty");
        }
        return false;
    }

    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> expression) {
        BinaryOperatorKind op = expression.getKind();
        if (op != BinaryOperatorKind.EQ && op != BinaryOperatorKind.NE) {
            return;
        }
        CtExpression lhs = expression.getLeftHandOperand();
        CtExpression rhs = expression.getRightHandOperand();
        if (this.isExceptionObject(lhs) || this.isExceptionObject(rhs)) {
            return;
        }
        if (!(lhs.getType() instanceof CtArrayTypeReference) && !this.getTypeAnnotation(lhs).is(TypeClassification.SuspiciousEqualsOperator)) {
            return;
        }
        WarningLevel level = WarningLevel.LEVEL_2;
        if (lhs instanceof CtLiteral || rhs instanceof CtLiteral) {
            level = WarningLevel.LEVEL_1;
        } else if (this.getCurrentMethod() != null && this.getCurrentMethod().getBody() != null && !this.getCurrentMethod().getBody().getStatements().isEmpty() && this.getCurrentMethod().getBody().getStatement(0) == lhs.getParent(CtStatement.class) && (RulesUtils.isParameter(lhs) || RulesUtils.isParameter(rhs))) {
            level = WarningLevel.LEVEL_3;
        }
        if (level != WarningLevel.LEVEL_1 && this.checked.computeIfAbsent(this::getComparedStrings).contains(new ComparedPair((CtElement)lhs, (CtElement)rhs))) {
            return;
        }
        PvsStudioRule.Pattern rule = this.commonRule;
        WarningLevel warningLevel = level = this.isInsideTestSources((CtElement)expression) ? WarningLevel.LEVEL_3 : level;
        if (lhs.getType() instanceof CtArrayTypeReference) {
            rule = this.arraysRule;
        } else if (this.getTypes().isSubtypeOf(lhs, "java.lang.String")) {
            rule = this.stringsRule;
        } else if (this.getTypes().isSubtypeOf(lhs, "java.lang.Number")) {
            rule = this.numbersRule;
        }
        rule.add((CtElement)expression, lhs, rhs).setLevel(level);
    }

    private static class ComparedPair {
        final CtElement first;
        final CtElement second;

        ComparedPair(CtElement f, CtElement s) {
            this.first = f;
            this.second = s;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ComparedPair)) {
                return false;
            }
            ComparedPair other = (ComparedPair)obj;
            return this.first.equals((Object)other.first) && this.second.equals((Object)other.second) || this.first.equals((Object)other.second) && this.second.equals((Object)other.first);
        }

        public int hashCode() {
            return this.first.hashCode() ^ this.second.hashCode();
        }
    }
}

