/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.declaration.ModifierKind;

public class V6011
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("The %2$s of the '%3$s' type is compared to a value of the '%4$s' type.").setExtendedMessage("The '%s' %s of the '%s' type is compared to a value of the '%s' type.").setCwe(682).setSastId("CERT-NUM13-J").build();

    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        if (operator.getKind() != BinaryOperatorKind.EQ && operator.getKind() != BinaryOperatorKind.NE && operator.getKind() != BinaryOperatorKind.LT && operator.getKind() != BinaryOperatorKind.LE && operator.getKind() != BinaryOperatorKind.GT && operator.getKind() != BinaryOperatorKind.GE) {
            return;
        }
        CtExpression left = operator.getLeftHandOperand();
        CtExpression right = operator.getRightHandOperand();
        boolean isLeftReal = RulesUtils.isRealType(left);
        boolean isRightReal = RulesUtils.isRealType(right);
        boolean isLeftInteger = RulesUtils.isIntegerType(left);
        boolean isRightInteger = RulesUtils.isIntegerType(right);
        if (isLeftReal && isRightInteger || isRightReal && isLeftInteger) {
            String kind;
            double realValue;
            CtExpression integerExpression;
            CtExpression realExpression = isLeftReal ? left : right;
            CtExpression ctExpression = integerExpression = isLeftInteger ? left : right;
            if (realExpression instanceof CtLiteral) {
                CtLiteral literal = (CtLiteral)realExpression;
                if (literal.getValue() instanceof Double) {
                    realValue = (Double)literal.getValue();
                } else if (literal.getValue() instanceof Float) {
                    realValue = ((Float)literal.getValue()).floatValue();
                } else {
                    return;
                }
                kind = "literal";
            } else if (realExpression instanceof CtVariableRead) {
                CtVariableRead varRead = (CtVariableRead)realExpression;
                CtVariable<?> decl = this.getDeclaration(varRead.getVariable());
                if (decl == null) {
                    return;
                }
                if (!decl.getModifiers().contains(ModifierKind.FINAL)) {
                    return;
                }
                CtExpression defaultExpression = decl.getDefaultExpression();
                if (!(defaultExpression instanceof CtLiteral)) {
                    return;
                }
                CtLiteral literal = (CtLiteral)defaultExpression;
                if (literal.getValue() instanceof Float) {
                    realValue = ((Float)literal.getValue()).floatValue();
                } else if (literal.getValue() instanceof Double) {
                    realValue = (Double)literal.getValue();
                } else {
                    return;
                }
                kind = "constant";
            } else {
                return;
            }
            if (realValue % 1.0 == 0.0) {
                return;
            }
            String realTypeName = realExpression.getType().getSimpleName();
            String integerTypeName = integerExpression.getType().getSimpleName();
            this.rule.add((CtElement)operator, realExpression, kind, realTypeName, integerTypeName);
        }
    }
}

