/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.FunctionClassification;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;

public class V6010
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("The return value of function is required to be utilized.").setExtendedMessage("The return value of function '%s' is required to be utilized.").setCwe(252).setSastId("CERT-EXP00-J").build();

    public boolean isForThirdStatement(CtElement statement, CtElement invocation) {
        if (!(statement instanceof CtFor)) {
            return false;
        }
        CtFor forStatement = (CtFor)statement;
        return forStatement.getForUpdate() != null && forStatement.getForUpdate().stream().anyMatch(st -> st == invocation);
    }

    public boolean isCollectException(CtAbstractInvocation<?> invocation) {
        CtExecutableReference executable = invocation.getExecutable();
        CtTypeReference declaringType = executable.getDeclaringType();
        if (declaringType == null) {
            return false;
        }
        boolean isException = false;
        if (declaringType.getQualifiedName().equals("java.util.stream.Stream") && executable.getSimpleName().equals("collect")) {
            isException = Optional.of(invocation).map(CtAbstractInvocation::getArguments).filter(Predicate.not(List::isEmpty)).map(list -> (CtExpression)list.get(0)).filter(CtInvocation.class::isInstance).map(CtInvocation.class::cast).map(CtAbstractInvocation::getArguments).filter(Predicate.not(List::isEmpty)).map(list -> list.get(0)).filter(CtLambda.class::isInstance).map(CtLambda.class::cast).map(CtLambda::getExpression).filter(CtVariableRead.class::isInstance).isPresent();
        }
        return isException;
    }

    private void visitAbstractInvocation(CtAbstractInvocation<?> invocation) {
        if (!this.getMethodAnnotation(invocation).is(FunctionClassification.NoDiscard)) {
            return;
        }
        CtElement e = invocation.getParent();
        if (e instanceof CtBlock || this.isForThirdStatement(e, (CtElement)invocation)) {
            if (this.isCollectException(invocation)) {
                return;
            }
            this.rule.add((CtElement)invocation, RulesUtils.getFunctionName(invocation)).setLevel(this.isInsideTestSources((CtElement)invocation) ? WarningLevel.LEVEL_3 : WarningLevel.LEVEL_1);
        }
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        this.visitAbstractInvocation((CtAbstractInvocation<?>)invocation);
    }

    @Override
    public <T> void visitCtConstructorCall(CtConstructorCall<T> invocation) {
        this.visitAbstractInvocation((CtAbstractInvocation<?>)invocation);
    }
}

