/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.Annotation;
import com.pvsstudio.core.Constraint;
import com.pvsstudio.core.Context;
import com.pvsstudio.core.IntegerVirtualValue;
import com.pvsstudio.core.OptionalInt;
import com.pvsstudio.core.Result;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.rules.WarningAdapter;
import com.pvsstudio.warnings.WarningLevel;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtTypeReference;

public class V6009
extends PvsStudioRule {
    private final PvsStudioRule.PatternBuilder ruleBuilder = new PvsStudioRule.PatternBuilder().setCwe(628);
    private final PvsStudioRule.Pattern ruleThisEquals = this.ruleBuilder.setMessage("Function '%1$s' receives an odd argument. An object '%2$s' is used as an argument to its own method.").build();
    private final PvsStudioRule.Pattern ruleEquals = this.ruleBuilder.setMessage("Function '%1$s' receives an odd argument. The '%2$s' argument was passed several times.").build();
    private final PvsStudioRule.Pattern ruleLessOrEquals = this.ruleBuilder.setMessage("Function '%1$s' receives an odd arguments. The '%2$s' argument should not be greater than '%3$s'.").build();
    private final PvsStudioRule.Pattern ruleNegative = this.ruleBuilder.setMessage("The '%1$s' function could receive a negative value while non-negative value is expected. Inspect argument: %2$s.").build();
    private final PvsStudioRule.Pattern rulePreciseNegative = this.ruleBuilder.setMessage("The '%1$s' function receives the '%2$s' value while non-negative value is expected. Inspect argument: %3$s.").build();
    private final PvsStudioRule.Pattern ruleIntervalNegative = this.ruleBuilder.setMessage("The '%1$s' function could receive the '%2$s' value while non-negative value is expected. Inspect argument: %3$s.").build();
    private final PvsStudioRule.Pattern ruleNull = this.ruleBuilder.setMessage("The '%1$s' function receives null value while non-null value is expected. Inspect argument: %2$s.").build();
    private final PvsStudioRule.Pattern ruleNotEmptyList = this.ruleBuilder.setMessage("The '%2$s' collection is empty. The call of the '%1$s' function is senseless.").build();
    private final PvsStudioRule.Pattern ruleDateRange = this.ruleBuilder.setMessage("The '%1$s' function receives an odd argument. Inspect argument: %2$s.").build();
    private final PvsStudioRule.Pattern ruleNotEmptyString = this.ruleBuilder.setMessage("The '%1$s' function receives empty string while non-empty string is expected. Inspect argument: %2$s.").build();
    private final PvsStudioRule.Pattern ruleWrongChar = this.ruleBuilder.setMessage("Buffer capacity is set to '%1$s' using a char value. Most likely, the '%2$s' symbol was supposed to be placed in the buffer.").build();
    private final PvsStudioRule.Pattern ruleWrongCharUnknown = this.ruleBuilder.setMessage("Buffer capacity is set using a char value. Most likely, the '%1$s' was supposed to be placed in the buffer.").build();

    @Override
    public void visitContractFailure(@NotNull CtAbstractInvocation<?> invocation, @NotNull Context context, @NotNull Annotation annotation, @NotNull Constraint constraint, @NotNull Stream<Map.Entry<Integer, CtElement>> usedArguments, @NotNull Result result) {
        if (annotation.interproceduralInformation() != 0L) {
            return;
        }
        List args = usedArguments.collect(Collectors.toList());
        if (args.isEmpty()) {
            return;
        }
        String funcName = RulesUtils.getFunctionName(invocation);
        WarningAdapter warning = null;
        Map.Entry firstArg = (Map.Entry)args.get(0);
        switch (constraint) {
            case EmptyOptional: 
            case IndexOutOfBounds: 
            case GreaterOrEquals: {
                return;
            }
            case Negative: {
                IntegerVirtualValue value = this.getValue((CtElement)firstArg.getValue()).toInteger();
                if (value != null) {
                    if (value.maxPrecise().isPresent() && value.maxPrecise().get().toLong().isPresent() && (value.maxPrecise().get().toLong().get() == Integer.MAX_VALUE || value.maxPrecise().get().toLong().get() == Integer.MIN_VALUE)) {
                        return;
                    }
                    if (value.singletonValue().isPresent()) {
                        warning = this.rulePreciseNegative.add((CtElement)invocation, funcName, value.min(), firstArg.getKey());
                        break;
                    }
                    if (value.minPrecise().isPresent()) {
                        warning = this.ruleIntervalNegative.add((CtElement)invocation, funcName, value.min(), firstArg.getKey());
                        break;
                    }
                    warning = this.ruleNegative.add((CtElement)invocation, funcName, firstArg.getKey());
                    break;
                }
                warning = this.ruleNegative.add((CtElement)invocation, funcName, firstArg.getKey());
                break;
            }
            case NotEquals: {
                if ((Integer)firstArg.getKey() == 0) {
                    warning = this.ruleThisEquals.add((CtElement)invocation, funcName, firstArg.getValue());
                    break;
                }
                warning = this.ruleEquals.add((CtElement)invocation, funcName, firstArg.getValue());
                break;
            }
            case LessOrEquals: {
                warning = this.ruleLessOrEquals.add((CtElement)invocation, funcName, firstArg.getValue(), ((Map.Entry)args.get(1)).getValue());
                break;
            }
            case Null: {
                warning = this.ruleNull.add((CtElement)invocation, funcName, firstArg.getKey());
                break;
            }
            case NotEmptyList: {
                if (invocation instanceof CtTargetedExpression) {
                    warning = this.ruleNotEmptyList.add((CtElement)invocation, funcName, ((CtTargetedExpression)invocation).getTarget());
                    break;
                }
                return;
            }
            case DateBounds: {
                warning = this.ruleDateRange.add((CtElement)invocation, funcName, firstArg.getKey());
                break;
            }
            case NotEmptyString: {
                warning = this.ruleNotEmptyString.add((CtElement)invocation, funcName, firstArg.getKey());
                break;
            }
        }
        assert (warning != null);
        warning.setLevel(this.isInsideTestSources((CtElement)invocation) ? WarningLevel.LEVEL_3 : RulesUtils.getLevel(result));
    }

    @Override
    public <T> void visitCtConstructorCall(CtConstructorCall<T> invocation) {
        CtTypeReference arg;
        String qualifiedName;
        super.visitCtConstructorCall(invocation);
        if (invocation.getExecutable().getDeclaringType() != null && invocation.getArguments().size() == 1 && ((qualifiedName = invocation.getExecutable().getDeclaringType().getQualifiedName()).equals("java.lang.StringBuilder") || qualifiedName.equals("java.lang.StringBuffer")) && (arg = ((CtExpression)invocation.getArguments().get(0)).getType()) != null && (arg.equals((Object)invocation.getFactory().Type().CHARACTER) || arg.equals((Object)invocation.getFactory().Type().CHARACTER_PRIMITIVE))) {
            OptionalInt charCode = this.getValue((CtElement)invocation.getArguments().get(0)).getVirtualValue().toInt();
            if (charCode.isPresent()) {
                this.ruleWrongChar.add((CtElement)invocation, charCode.get(), Character.valueOf((char)charCode.get()));
            } else {
                this.ruleWrongCharUnknown.add((CtElement)invocation, invocation.getArguments().get(0));
            }
        }
    }
}

