/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.Annotation;
import com.pvsstudio.core.Constraint;
import com.pvsstudio.core.Context;
import com.pvsstudio.core.IndexArray;
import com.pvsstudio.core.Result;
import com.pvsstudio.core.TypeClassification;
import com.pvsstudio.core.Value;
import com.pvsstudio.core.Variable;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.rules.WarningAdapter;
import com.pvsstudio.warnings.WarningLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExecutableReferenceExpression;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.visitor.EarlyTerminatingScanner;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6008
extends PvsStudioRule {
    private final PvsStudioRule.Pattern dereference = new PvsStudioRule.PatternBuilder().setMessage("Null dereference.").setExtendedMessage("Null dereference of '%s'%s.").setCwe(476).build();
    private final PvsStudioRule.Pattern dereferenceNull = new PvsStudioRule.PatternBuilder().setMessage("Null dereference.").setExtendedMessage("Dereference of '%s'%s.").setCwe(476).build();
    private final PvsStudioRule.Pattern afterConditionDereference = new PvsStudioRule.PatternBuilder().setMessage("Potential null dereference.").setExtendedMessage("Potential null dereference of '%s'.").setLevel(WarningLevel.LEVEL_2).setCwe(690).build();
    private final PvsStudioRule.Pattern potentialDereference = new PvsStudioRule.PatternBuilder().setMessage("Potential null dereference.").setExtendedMessage("Potential null dereference of '%s'%s.").setLevel(WarningLevel.LEVEL_3).setCwe(690).build();
    private final PvsStudioRule.Pattern potentialDereferenceNull = new PvsStudioRule.PatternBuilder().setMessage("Potential null dereference.").setExtendedMessage("Potential dereference of '%s'%s.").setLevel(WarningLevel.LEVEL_3).setCwe(690).build();
    private final PvsStudioRule.MethodInformation<Map<Variable, WarningLevel>> variables = new PvsStudioRule.MethodInformation<Map>(HashMap::new);

    @Override
    protected boolean shouldProduceWarnings() {
        return super.shouldProduceWarnings() && !this.isSuppressed("null", "nullDereference");
    }

    private boolean isTestedInAssert(CtElement body, CtExpression<?> expression) {
        CtExpression copyExpression = expression.clone();
        copyExpression = copyExpression.setTypeCasts(new ArrayList());
        final CtStatement parent = (CtStatement)expression.getParent(CtStatement.class);
        final MutableBoolean isInAssert = new MutableBoolean(false);
        final CtExpression finalExpression = copyExpression;
        EarlyTerminatingScanner<Boolean> scanner = new EarlyTerminatingScanner<Boolean>(){
            {
                this.setResult(false);
            }

            public void scan(CtElement element) {
                if (element == parent) {
                    this.terminate();
                    return;
                }
                if (isInAssert.getValue().booleanValue() && element instanceof CtExpression && RulesUtils.equals(element, (CtElement)finalExpression)) {
                    this.setResult(true);
                    this.terminate();
                    return;
                }
                super.scan(element);
            }

            public <T> void visitCtInvocation(CtInvocation<T> invocation) {
                boolean old = isInAssert.getValue();
                String name = invocation.getExecutable().getSimpleName().toLowerCase();
                if (!old && (name.contains("assert") || name.contains("notnull") || name.contains("nonnull"))) {
                    isInAssert.setTrue();
                }
                super.visitCtInvocation(invocation);
                isInAssert.setValue(old);
            }
        };
        scanner.scan(body);
        return (Boolean)scanner.getResult();
    }

    private void apply(CtExpression<?> target) {
        this.apply(target, null, null);
    }

    private void apply(CtExpression<?> target, IndexArray path, CtAbstractInvocation<?> inv) {
        PvsStudioRule.Pattern pattern;
        Value exp = this.getValue((CtElement)target);
        if (exp.isEmpty()) {
            return;
        }
        CtElement additionalElement = null;
        switch (this.constraints().notNull(exp, this.getDataFlow().getExpressionIndex((CtElement)target))) {
            case Level1: {
                pattern = RulesUtils.isNullLiteral(target) ? this.dereferenceNull : this.dereference;
                break;
            }
            case Level2: {
                pattern = this.afterConditionDereference;
                additionalElement = this.getDataFlow().getExpressionByIndex(exp.toPointer().getConditionTree());
                break;
            }
            case Level3: {
                pattern = RulesUtils.isNullLiteral(target) ? this.potentialDereferenceNull : this.potentialDereference;
                break;
            }
            default: {
                return;
            }
        }
        if (!this.isExceptionToUsingInAnonymousClassOrLambda(target) && (this.isInMethodOfAnonymousClass(target) || this.isInLambda(target))) {
            return;
        }
        if (this.getCurrentMethod() != null) {
            if (this.isTestedInAssert((CtElement)this.getCurrentMethod(), target)) {
                return;
            }
            Variable var = exp.getVariable();
            if (var != null) {
                Map<Variable, WarningLevel> map = this.variables.current();
                WarningLevel level = map.get(var);
                if (level != null && level.compareTo(pattern.getLevel()) <= 0) {
                    return;
                }
                map.put(var, pattern.getLevel());
            }
        }
        String additionalString = "";
        if (inv != null) {
            additionalString = String.format(" in %s '%s'", inv instanceof CtConstructorCall ? "constructor" : "function", inv instanceof CtConstructorCall ? ((CtConstructorCall)inv).getType().getSimpleName() : inv.getExecutable().getSimpleName());
        }
        WarningAdapter warning = pattern.add((CtElement)target, target, additionalString);
        if (additionalElement != null) {
            warning.addSourcePosition(additionalElement, this.getModule());
        }
        this.addInterproceduralPositions(warning, path);
        warning.setSastId(this.mergeSastId("CERT-EXP01-J", "SEC-NULL"));
    }

    public <S> void visitCtSwitch(CtSwitch<S> switchStatement) {
        this.apply(switchStatement.getSelector());
    }

    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        if (operator.getKind() == BinaryOperatorKind.INSTANCEOF) {
            return;
        }
        if ((operator.getKind() == BinaryOperatorKind.OR || operator.getKind() == BinaryOperatorKind.AND || RulesUtils.isPrimitive(operator.getLeftHandOperand()) || RulesUtils.isPrimitive(operator.getRightHandOperand())) && !this.getTypeAnnotation(operator.getLeftHandOperand()).is(TypeClassification.String) && !this.getTypeAnnotation(operator.getRightHandOperand()).is(TypeClassification.String)) {
            this.apply(operator.getLeftHandOperand());
            this.apply(operator.getRightHandOperand());
        }
    }

    public void visitCtIf(CtIf ifElement) {
        this.apply(ifElement.getCondition());
    }

    public <T> void visitCtFieldRead(CtFieldRead<T> fieldRead) {
        this.apply(fieldRead.getTarget());
    }

    public <T> void visitCtFieldWrite(CtFieldWrite<T> fieldWrite) {
        this.apply(fieldWrite.getTarget());
    }

    public <T> void visitCtConditional(CtConditional<T> conditional) {
        this.apply(conditional.getCondition());
    }

    @Override
    public void visitContractFailure(@NotNull CtAbstractInvocation<?> invocation, @NotNull Context context, @NotNull Annotation annotation, @NotNull Constraint constraint, @NotNull Stream<Map.Entry<Integer, CtElement>> usedArguments, @NotNull Result result) {
        if (annotation.interproceduralInformation() == 0L || constraint != Constraint.Null) {
            return;
        }
        usedArguments.findFirst().map(e -> (CtExpression)e.getValue()).ifPresent(e -> this.apply((CtExpression<?>)e, context.getPath(), invocation));
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        this.apply(invocation.getTarget());
        CtExecutable<?> method = this.getDeclaration(invocation.getExecutable());
        if (method != null) {
            ((EntryStream)StreamEx.of((Collection)method.getParameters()).zipWith(invocation.getArguments().stream()).filter(param -> ((CtParameter)param.getKey()).getAnnotations().stream().map(this::getTypeAnnotation).anyMatch(annotation -> annotation.is(TypeClassification.NotNull)))).map(Map.Entry::getValue).forEach(e -> this.apply((CtExpression<?>)e, null, (CtAbstractInvocation<?>)invocation));
        }
        this.scanContractFailures((CtAbstractInvocation<?>)invocation);
    }

    public <T, E extends CtExpression<?>> void visitCtExecutableReferenceExpression(CtExecutableReferenceExpression<T, E> methodReference) {
        this.apply(methodReference.getTarget());
    }

    private boolean isInMethodOfAnonymousClass(@NotNull CtExpression<?> expression) {
        CtClass anonymousClass = (CtClass)expression.getParent((Filter)new TypeFilter(CtClass.class));
        if (anonymousClass == null || !anonymousClass.isAnonymous()) {
            return false;
        }
        CtVariableRead variableRead = (CtVariableRead)expression;
        CtClass variableOwnerClass = (CtClass)variableRead.getVariable().getDeclaration().getParent((Filter)new TypeFilter(CtClass.class));
        return (variableOwnerClass == null || !variableOwnerClass.equals((Object)anonymousClass)) && RulesUtils.getParentBounded((CtElement)variableRead, (CtElement)anonymousClass, CtMethod.class) != null;
    }

    private boolean isInLambda(@NotNull CtExpression<?> expression) {
        CtLambda lambda = (CtLambda)expression.getParent((Filter)new TypeFilter(CtLambda.class));
        if (lambda == null) {
            return false;
        }
        CtLambda variableOwnerLambda = (CtLambda)((CtVariableRead)expression).getVariable().getDeclaration().getParent((Filter)new TypeFilter(CtLambda.class));
        return variableOwnerLambda == null || !variableOwnerLambda.equals((Object)lambda);
    }

    private boolean isExceptionToUsingInAnonymousClassOrLambda(@NotNull CtExpression<?> expression) {
        if (!(expression instanceof CtVariableRead) || expression instanceof CtFieldRead && ((CtFieldRead)expression).getTarget() instanceof CtVariableRead) {
            return true;
        }
        CtVariable ctVariable = ((CtVariableRead)expression).getVariable().getDeclaration();
        return ctVariable == null || ctVariable.isFinal() || ctVariable instanceof CtLocalVariable || ctVariable instanceof CtParameter;
    }
}

