/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.Allocation;
import com.pvsstudio.core.PointerVirtualValue;
import com.pvsstudio.core.Value;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.rules.WarningAdapter;
import com.pvsstudio.warnings.WarningLevel;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtExecutableReferenceExpression;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtWhile;
import spoon.reflect.declaration.CtElement;

public class V6007
extends PvsStudioRule {
    private final PvsStudioRule.Pattern alwaysTrue = new PvsStudioRule.PatternBuilder(this).setMessage("Expression is always true.").setExtendedMessage("Expression '%s' is always true.").setCwe(571).setSastId("CERT-MSC57-J").build();
    private final PvsStudioRule.Pattern alwaysFalse = new PvsStudioRule.PatternBuilder(this).setMessage("Expression is always false.").setExtendedMessage("Expression '%s' is always false.").setCwe(570).setSastId("CERT-MSC57-J").build();
    private static final String NOT_NULL_FROM_NEW_SUFFIX = "New returns not-null reference.";

    private void addNewPattern(CtExpression<?> e, WarningAdapter warning) {
        CtExpression reference;
        if (!(e instanceof CtBinaryOperator)) {
            return;
        }
        CtBinaryOperator op = (CtBinaryOperator)e;
        if (op.getKind() != BinaryOperatorKind.EQ && op.getKind() != BinaryOperatorKind.NE) {
            return;
        }
        CtExpression leftHandOperand = op.getLeftHandOperand();
        CtExpression rightHandOperand = op.getRightHandOperand();
        if (RulesUtils.isNullLiteral((CtElement)leftHandOperand)) {
            reference = rightHandOperand;
        } else if (RulesUtils.isNullLiteral((CtElement)rightHandOperand)) {
            reference = leftHandOperand;
        } else {
            return;
        }
        PointerVirtualValue value = this.getValue((CtElement)reference).toPointer();
        if (value == null || !value.isNotNullPointer() || value.getAllocation() != Allocation.New) {
            return;
        }
        warning.addSuffix(NOT_NULL_FROM_NEW_SUFFIX);
        CtElement allocationElement = this.getDataFlow().getExpressionByIndex(value.getAllocationTree());
        if (allocationElement != null) {
            warning.addSourcePosition(allocationElement, this.getModule());
        }
    }

    private CtExpression<?> getExpressionForAnalysis(CtExpression<?> e) {
        CtBinaryOperator operator;
        if (e instanceof CtAssignment) {
            return this.getExpressionForAnalysis(((CtAssignment)e).getAssignment());
        }
        if (e instanceof CtBinaryOperator ? (operator = (CtBinaryOperator)e).getKind() == BinaryOperatorKind.AND || operator.getKind() == BinaryOperatorKind.OR : e instanceof CtConditional) {
            return null;
        }
        return e;
    }

    private void checkExpression(CtExpression<?> e, boolean isCondition) {
        PvsStudioRule.Pattern pattern;
        if ((e = this.getExpressionForAnalysis(e)) == null) {
            return;
        }
        if (!RulesUtils.isPrimitive(e) && !(e instanceof CtExecutableReferenceExpression)) {
            return;
        }
        Value value = this.getValue((CtElement)e);
        switch (value.toBool()) {
            case True: {
                pattern = this.alwaysTrue;
                break;
            }
            case False: {
                pattern = this.alwaysFalse;
                break;
            }
            default: {
                return;
            }
        }
        if (!this.isConstantExpression(e)) {
            WarningAdapter warning = pattern.add((CtElement)e, e);
            this.addNewPattern(e, warning);
            if (!isCondition && (e instanceof CtVariableAccess || e instanceof CtUnaryOperator && ((CtUnaryOperator)e).getOperand() instanceof CtVariableAccess)) {
                warning.setLevel(WarningLevel.LEVEL_3);
            }
        }
    }

    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        if (operator.getKind() != BinaryOperatorKind.AND && operator.getKind() != BinaryOperatorKind.OR) {
            return;
        }
        this.checkExpression(operator.getLeftHandOperand(), true);
        this.checkExpression(operator.getRightHandOperand(), true);
    }

    public void visitCtIf(CtIf ifStatement) {
        this.checkExpression(ifStatement.getCondition(), true);
    }

    public <T> void visitCtConditional(CtConditional<T> expression) {
        this.checkExpression(expression.getCondition(), true);
    }

    private <T> boolean isBoolean(CtExpression<T> e) {
        return RulesUtils.isBooleanOrBoxed(e);
    }

    public <T> void visitCtReturn(CtReturn<T> returnStatement) {
        if (this.isBoolean(returnStatement.getReturnedExpression())) {
            this.checkExpression(returnStatement.getReturnedExpression(), false);
        }
    }

    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> assignment) {
        if (this.isBoolean(assignment.getAssigned())) {
            this.checkExpression(assignment.getAssignment(), false);
        }
    }

    public <T> void visitCtLocalVariable(CtLocalVariable<T> variable) {
        if (this.isBoolean(variable.getAssignment())) {
            this.checkExpression(variable.getAssignment(), false);
        }
    }

    public <T, E extends CtExpression<?>> void visitCtExecutableReferenceExpression(CtExecutableReferenceExpression<T, E> methodReference) {
        this.checkExpression((CtExpression<?>)methodReference, false);
    }

    @Override
    public void visitCtFor(CtFor forLoop) {
        this.checkExpression(forLoop.getExpression(), true);
    }

    @Override
    public void visitCtWhile(CtWhile whileLoop) {
        this.checkExpression(whileLoop.getLoopingExpression(), true);
    }

    @Override
    public void visitCtDo(CtDo doLoop) {
        this.checkExpression(doLoop.getLoopingExpression(), true);
    }
}

