/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtElement;

public class V6004
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("The 'then' statement is equivalent to the 'else' statement.").setCwe(691).build();

    private boolean containsTodoComment(CtBlock<?> block) {
        return this.getComments((CtElement)block).stream().map(CtComment::getContent).map(String::toLowerCase).anyMatch(content -> content.contains("todo ") || content.contains("todo: ") || content.contains("todo("));
    }

    private boolean isElseClause(CtElement element) {
        if (element == null) {
            return false;
        }
        CtElement parent = element.getParent();
        if (parent == null) {
            return false;
        }
        if (!(parent instanceof CtBlock)) {
            return false;
        }
        CtElement topParent = parent.getParent();
        if (!(topParent instanceof CtIf)) {
            return false;
        }
        CtIf ifElement = (CtIf)topParent;
        CtStatement elseElement = ifElement.getElseStatement();
        return elseElement != null && elseElement == parent;
    }

    public void visitCtIf(CtIf ifElement) {
        CtStatement thenStatement = ifElement.getThenStatement();
        CtStatement elseStatement = ifElement.getElseStatement();
        if (elseStatement == null) {
            return;
        }
        if (!(thenStatement instanceof CtBlock) || !(elseStatement instanceof CtBlock)) {
            return;
        }
        CtBlock thenBody = (CtBlock)thenStatement;
        CtBlock elseBody = (CtBlock)elseStatement;
        if (thenBody.getStatements().isEmpty() || elseBody.getStatements().isEmpty()) {
            return;
        }
        if (RulesUtils.equals((CtElement)thenBody, (CtElement)elseBody)) {
            CtElement parent;
            WarningLevel level = WarningLevel.LEVEL_1;
            if (this.containsTodoComment(thenBody) || this.containsTodoComment(elseBody)) {
                level = WarningLevel.LEVEL_2;
            }
            if (this.isElseClause((CtElement)ifElement)) {
                level = WarningLevel.LEVEL_3;
            }
            if (ifElement.getParent() != null && this.isElseClause(parent = ifElement.getParent().getParent())) {
                return;
            }
            this.rule.add((CtElement)thenStatement, new Object[0]).setLevel(level).addSourcePosition((CtElement)elseStatement, this.getModule());
        }
    }
}

