/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.rules.V6001;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtElement;

public class V6003
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("The use of 'if (A) {...} else if (A) {...}' pattern was detected. There is a probability of logical error presence.").setExtendedMessage("The use of 'if (%1$s) {...} else if (%1$s) {...}' pattern was detected. There is a probability of logical error presence.").setCwe(570).setSastId("CERT-MSC57-J").build();

    private void add(List<CtExpression<?>> expressions) {
        if ((expressions = expressions.stream().collect(Collectors.groupingBy(e -> (CtIf)e.getParent(CtIf.class), IdentityHashMap::new, Collectors.toList())).entrySet().stream().flatMap(e -> Stream.of((CtExpression)((List)e.getValue()).get(0))).collect(Collectors.toList())).size() < 2) {
            return;
        }
        expressions.sort(Comparator.comparingInt(e -> e.getPosition().getLine()));
        this.rule.add((CtElement)expressions.get(0), expressions.get(0)).addSourcePositions(expressions.subList(1, expressions.size()), this.getModule());
    }

    public void visitCtIf(CtIf ifStatement) {
        CtStatement st;
        CtBlock elseBlock;
        CtBlock parentBlock;
        if (ifStatement.getElseStatement() == null) {
            return;
        }
        CtElement parent = ifStatement.getParent();
        if (parent instanceof CtBlock && (parentBlock = (CtBlock)parent).getStatements().size() == 1 && parentBlock.getParent() instanceof CtIf) {
            return;
        }
        ArrayList expressions = new ArrayList();
        RulesUtils.getSubExpressions(BinaryOperatorKind.OR, ifStatement.getCondition(), expressions);
        CtIf elseIf = ifStatement;
        while (elseIf.getElseStatement() instanceof CtBlock && (elseBlock = (CtBlock)elseIf.getElseStatement()).getStatements().size() == 1 && (st = elseBlock.getStatement(0)) instanceof CtIf) {
            elseIf = (CtIf)st;
            RulesUtils.getSubExpressions(BinaryOperatorKind.OR, elseIf.getCondition(), expressions);
        }
        V6001.analyzeLogicalExpression(this.getDataFlow(), expressions, this::add);
    }
}

