/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.List;
import java.util.stream.Collectors;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtLoop;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtEnumValue;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6002
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("The switch statement does not cover all values of the '%s' enum.").setExtendedMessage("The switch statement does not cover all values of the '%s' enum: %s.").setSastId("CERT-MSC57-J").build();

    @Override
    protected boolean shouldProduceWarnings() {
        return super.shouldProduceWarnings() && !this.isSuppressed("incomplete-switch");
    }

    private String getCaseVarSimpleName(CtCase<?> lbl) {
        CtFieldRead fieldRead;
        CtFieldReference caseVar;
        CtExpression expr = lbl.getCaseExpression();
        if (expr instanceof CtFieldRead && (caseVar = (fieldRead = (CtFieldRead)expr).getVariable()) != null) {
            return caseVar.getSimpleName();
        }
        return "";
    }

    private <S> List<CtEnumValue<?>> getEnumValuesAbsentInSwitch(CtSwitch<S> switchStatement, List<CtEnumValue<?>> enumValues) {
        List cases = switchStatement.getCases();
        return enumValues.stream().filter(enumVal -> cases.stream().map(this::getCaseVarSimpleName).noneMatch(enumVal.toString()::equals)).collect(Collectors.toList());
    }

    private boolean isNoneException(String enumValueName) {
        String lowerName = enumValueName.toLowerCase();
        return lowerName.contains("none") || lowerName.contains("unknown") || lowerName.contains("notavailable") || lowerName.contains("any") || lowerName.contains("invalid") || lowerName.contains("never") || lowerName.contains("undetermined") || lowerName.contains("default") || lowerName.contains("empty") || lowerName.contains("notset") || lowerName.contains("noset") || lowerName.equals("na");
    }

    private boolean isEndException(String enumValueName) {
        String lowerName = enumValueName.toLowerCase();
        return lowerName.contains("end") || lowerName.contains("num") || lowerName.contains("count") || lowerName.contains("silent") || lowerName.contains("all") || lowerName.contains("max");
    }

    private boolean isOutSwitchCheckException(CtSwitch<?> switchStatement, CtExpression<?> selector, List<CtEnumValue<?>> absentInSwitch) {
        CtElement parent = switchStatement.getParent();
        if (parent.getParent() instanceof CtLoop) {
            parent = parent.getParent();
        }
        if (parent == null) {
            return false;
        }
        List binaryOperators = parent.getElements((Filter)new TypeFilter(CtBinaryOperator.class)).stream().filter(arg -> arg.getKind() == BinaryOperatorKind.EQ || arg.getKind() == BinaryOperatorKind.NE).collect(Collectors.toList());
        for (CtBinaryOperator operator : binaryOperators) {
            List elements = operator.getElements((Filter)new TypeFilter(CtFieldRead.class));
            for (CtFieldRead element : elements) {
                CtFieldReference variable = element.getVariable();
                if (variable == null || variable.getDeclaringType() == null || !RulesUtils.equals((CtElement)variable.getDeclaringType(), (CtElement)selector.getType()) || !absentInSwitch.stream().anyMatch(arg -> arg.getSimpleName().equals(variable.getSimpleName()))) continue;
                return true;
            }
        }
        return false;
    }

    public <S> void visitCtSwitch(CtSwitch<S> switchStatement) {
        CtExpression selector = switchStatement.getSelector();
        CtType<?> selectorType = this.getDeclaration(selector.getType());
        if (!(selectorType instanceof CtEnum)) {
            return;
        }
        CtEnum selectorEnum = (CtEnum)selectorType;
        List enumValues = selectorEnum.getEnumValues();
        if (enumValues.size() < 3) {
            return;
        }
        List cases = switchStatement.getCases();
        if (cases.stream().anyMatch(RulesUtils::isDefault)) {
            return;
        }
        List<CtEnumValue<?>> absentInSwitch = this.getEnumValuesAbsentInSwitch(switchStatement, enumValues);
        if (absentInSwitch.isEmpty()) {
            return;
        }
        if (absentInSwitch.size() > 4) {
            return;
        }
        if (cases.size() <= absentInSwitch.size()) {
            return;
        }
        String firstEnumValueName = ((CtEnumValue)enumValues.get(0)).toString();
        String lastEnumValueName = ((CtEnumValue)enumValues.get(enumValues.size() - 1)).toString();
        String preLastEnumValueName = ((CtEnumValue)enumValues.get(enumValues.size() - 2)).toString();
        if (absentInSwitch.size() == 1) {
            String absentValueName = absentInSwitch.get(0).toString();
            if (this.isNoneException(absentValueName)) {
                return;
            }
            if (absentValueName.equals(lastEnumValueName) && this.isEndException(absentValueName)) {
                return;
            }
            CtElement parent = switchStatement.getParent();
            if (parent instanceof CtBlock) {
                CtBlock parentBlock = (CtBlock)parent;
                boolean afterSwitch = false;
                for (CtStatement statement : parentBlock.getStatements()) {
                    if (statement == switchStatement) {
                        afterSwitch = true;
                        continue;
                    }
                    if (!afterSwitch) continue;
                    if (statement instanceof CtReturn) {
                        return;
                    }
                    break;
                }
            }
        } else if (absentInSwitch.size() == 2) {
            String firstAbsent = absentInSwitch.get(0).toString();
            String secondAbsent = absentInSwitch.get(1).toString();
            if (firstAbsent.equals(firstEnumValueName) && this.isNoneException(firstAbsent) && secondAbsent.equals(lastEnumValueName) && this.isEndException(secondAbsent)) {
                return;
            }
            if (firstAbsent.equals(preLastEnumValueName) && this.isEndException(firstAbsent) && secondAbsent.equals(lastEnumValueName) && this.isNoneException(secondAbsent)) {
                return;
            }
        }
        if (this.isOutSwitchCheckException(switchStatement, selector, absentInSwitch)) {
            return;
        }
        String absentInSwitchStr = absentInSwitch.stream().map(CtNamedElement::getSimpleName).collect(Collectors.joining(", "));
        this.rule.add((CtElement)switchStatement, selectorEnum.getSimpleName(), absentInSwitchStr).setLevel(absentInSwitch.size() == 1 && enumValues.size() > 3 ? WarningLevel.LEVEL_2 : WarningLevel.LEVEL_3);
    }
}

