/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.google.common.collect.Sets;
import com.pvsstudio.Lazy;
import com.pvsstudio.dataflow.DataFlow;
import com.pvsstudio.dataflow.VariablesCache;
import com.pvsstudio.helpers.TreeIterator;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.visitors.ModificationsScanner;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableObject;
import spoon.reflect.code.BinaryOperatorKind;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtCodeElement;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V6001
extends PvsStudioRule {
    private final PvsStudioRule.PatternBuilder base = new PvsStudioRule.PatternBuilder(this).setMessage("There are identical sub-expressions to the left and to the right of the '%2$s' operator.").setExtendedMessage("There are identical sub-expressions '%s' to the left and to the right of the '%s' operator.");
    private final PvsStudioRule.Pattern alwaysTrue = this.base.build();
    private final PvsStudioRule.Pattern alwaysFalse = this.base.build();
    private final PvsStudioRule.Pattern misprint = this.base.build();
    private final Map<BinaryOperatorKind, PvsStudioRule.Pattern> patterns = new EnumMap<BinaryOperatorKind, PvsStudioRule.Pattern>(BinaryOperatorKind.class);

    public V6001() {
        this.patterns.put(BinaryOperatorKind.AND, this.alwaysTrue);
        this.patterns.put(BinaryOperatorKind.OR, this.alwaysFalse);
        this.patterns.put(BinaryOperatorKind.LT, this.alwaysFalse);
        this.patterns.put(BinaryOperatorKind.GT, this.alwaysFalse);
        this.patterns.put(BinaryOperatorKind.NE, this.alwaysFalse);
        this.patterns.put(BinaryOperatorKind.LE, this.alwaysTrue);
        this.patterns.put(BinaryOperatorKind.GE, this.alwaysTrue);
        this.patterns.put(BinaryOperatorKind.EQ, this.alwaysTrue);
        this.patterns.put(BinaryOperatorKind.DIV, this.misprint);
        this.patterns.put(BinaryOperatorKind.MINUS, this.misprint);
        this.patterns.put(BinaryOperatorKind.BITAND, this.misprint);
        this.patterns.put(BinaryOperatorKind.BITOR, this.misprint);
        this.patterns.put(BinaryOperatorKind.BITXOR, this.misprint);
        this.patterns.put(BinaryOperatorKind.MOD, this.misprint);
    }

    private static boolean equals(VariablesCache vars, CtExpression<?> a, CtExpression<?> b) {
        return RulesUtils.equals(a, b) && !RulesUtils.isConstantExpression(vars, a);
    }

    private int getCwe(BinaryOperatorKind kind) {
        switch (kind) {
            case OR: 
            case LT: 
            case GT: 
            case NE: {
                return 570;
            }
            case AND: 
            case LE: 
            case GE: 
            case EQ: {
                return 571;
            }
        }
        return 0;
    }

    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        if (operator.getKind() == BinaryOperatorKind.AND || operator.getKind() == BinaryOperatorKind.OR) {
            CtElement parent = operator.getParent();
            if (parent instanceof CtBinaryOperator && ((CtBinaryOperator)parent).getKind() == operator.getKind()) {
                return;
            }
            V6001.analyzeLogicalExpression(this.getDataFlow(), RulesUtils.getSubExpressions(operator.getKind(), operator), expressions -> this.patterns.get(operator.getKind()).add((CtElement)expressions.get(0), expressions.get(0), RulesUtils.getOperatorText(operator.getKind())).setCwe(this.getCwe(operator.getKind())).addSourcePositions(expressions.subList(1, expressions.size()), this.getModule()));
            return;
        }
        if ((operator.getKind() == BinaryOperatorKind.EQ || operator.getKind() == BinaryOperatorKind.NE) && (RulesUtils.isRealType(operator.getLeftHandOperand()) || RulesUtils.isBoxedRealType(operator.getLeftHandOperand()))) {
            return;
        }
        PvsStudioRule.Pattern pattern = this.patterns.get(operator.getKind());
        if (pattern == null) {
            return;
        }
        if (operator.getKind() == BinaryOperatorKind.MINUS) {
            MutableObject inv = new MutableObject();
            if (operator.getLeftHandOperand() != null) {
                TreeIterator.forEach((CtCodeElement)operator.getLeftHandOperand(), (e, i) -> {
                    if (e instanceof CtInvocation) {
                        inv.setValue((Object)((CtInvocation)e));
                        return false;
                    }
                    return true;
                });
            }
            if (inv.getValue() != null && V6001.isRandomInvocation((CtInvocation)inv.getValue())) {
                return;
            }
        }
        if (V6001.equals(this.getDataFlow().getVariablesCache(), operator.getLeftHandOperand(), operator.getRightHandOperand())) {
            pattern.add((CtElement)operator, operator.getLeftHandOperand(), RulesUtils.getOperatorText(operator.getKind())).setCwe(this.getCwe(operator.getKind()));
        }
    }

    private static boolean isRandomInvocation(CtInvocation<?> invocation) {
        boolean flag = false;
        if (invocation.getTarget() != null && invocation.getTarget().getType() != null) {
            flag = invocation.getTarget().getType().getQualifiedName().toLowerCase().contains("random");
        }
        if (invocation.getExecutable() != null) {
            flag = flag || invocation.getExecutable().getSimpleName().toLowerCase().contains("random");
        }
        return flag;
    }

    static void analyzeLogicalExpression(DataFlow dfa, List<CtExpression<?>> expressions, Consumer<List<CtExpression<?>>> error) {
        List hasModifications = expressions.stream().map(e -> Lazy.of(ModificationsScanner.hasAnyModification((CtElement)e, dfa.getVariablesCache()))).collect(Collectors.toList());
        ArrayList<HashSet> res = new ArrayList<HashSet>();
        block0: for (int i = 0; i < expressions.size(); ++i) {
            CtExpression<?> l = expressions.get(i);
            for (int j = i + 1; j < expressions.size(); ++j) {
                CtExpression<?> r = expressions.get(j);
                if (V6001.equals(dfa.getVariablesCache(), l, r)) {
                    if (l.getElements((Filter)new TypeFilter(CtInvocation.class)).stream().map(dfa::getMethodAnnotation).anyMatch(arg -> arg != null && !arg.getAnnotation().getPure())) continue block0;
                    int leftIndex = i;
                    int rightIndex = j;
                    Optional<Set> equal = res.stream().filter(s -> s.contains(leftIndex) || s.contains(rightIndex)).findFirst();
                    if (equal.isPresent()) {
                        equal.get().add(i);
                        equal.get().add(j);
                    } else {
                        res.add(Sets.newHashSet((Object[])new Integer[]{i, j}));
                    }
                }
                if (((Boolean)((Lazy)hasModifications.get(j)).get()).booleanValue()) continue block0;
            }
        }
        res.forEach(s -> error.accept(s.stream().sorted().map(expressions::get).collect(Collectors.toList())));
    }
}

