/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.annotation.FlagAnnotation;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.TaintRule;
import com.pvsstudio.visitors.StringConcatenationVisitor;
import java.util.Objects;
import java.util.Optional;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtParameterReference;

public class V5337
extends TaintRule {
    private final PvsStudioRule.PatternBuilder ruleBuilder = new PvsStudioRule.PatternBuilder().setCwe(943).setSastId("OWASP-5.3.4").setSecId("SEC-TAINT").setMessage("Possible NoSQL injection. Potentially tainted data is used to create query.");

    @Override
    protected PvsStudioRule.PatternBuilder getPatternBuilder() {
        return this.ruleBuilder;
    }

    @Override
    protected FlagAnnotation getSanitizationAnnotation() {
        return FlagAnnotation.NOSQL_SANITIZATION;
    }

    @Override
    protected FlagAnnotation getSinkAnnotation() {
        return FlagAnnotation.NOSQL_INJECTION_SINK;
    }

    @Override
    protected String getExtendedMessage(String prefix, String type) {
        return "Possible NoSQL injection. Potentially tainted data " + prefix + " '%s' " + type + " is used to create query.";
    }

    @Override
    protected boolean useAsPublicConsideredSource(CtParameterReference<?> parameter, CtExecutable<?> executable) {
        Optional<CtParameter> parameterOptional = executable.getParameters().stream().filter(p -> p.getReference().equals((Object)parameter)).findFirst();
        return parameterOptional.isPresent() && Objects.requireNonNull(this.getJavaDataFlow()).getVariableUsages((CtVariable)parameterOptional.get()).anyMatch(StringConcatenationVisitor::hasConcatenation);
    }
}

