/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.annotation.Annotation;
import com.pvsstudio.annotation.FlagAnnotation;
import com.pvsstudio.dataflow.resolvers.XmlParserSanitizationResolver;
import com.pvsstudio.dataflow.taint.TaintResult;
import com.pvsstudio.dataflow.taint.TaintSource;
import com.pvsstudio.dataflow.taint.stategy.TaintRuleStrategy;
import com.pvsstudio.projects.Module;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.TaintRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.List;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtParameter;

public class V5335
extends TaintRule {
    private List<TaintResult> xmlParsersDeclarations;
    private CtElement parser;

    @Override
    protected PvsStudioRule.PatternBuilder getPatternBuilder() {
        return new PvsStudioRule.PatternBuilder(this).setMessage("Potential XXE vulnerability. Insecure XML parser is used to process potentially tainted data.").setSastId("OWASP-5.5.2").setSecId("SEC-TAINT").setCwe(611);
    }

    @Override
    protected FlagAnnotation getSanitizationAnnotation() {
        return FlagAnnotation.XXE_PARSER_SANITIZATION;
    }

    @Override
    protected FlagAnnotation getSinkAnnotation() {
        return FlagAnnotation.XML_PARSING_SINK;
    }

    @Override
    protected String getExtendedMessage(String prefix, String type) {
        Object parserString = "";
        if (!(this.parser instanceof CtInvocation)) {
            String parserPrefix = this.getPrefixForMessage(this.parser);
            String parserType = this.getTypeForMessage(this.parser);
            parserString = " " + parserPrefix + " '" + String.valueOf(this.parser) + "' " + parserType;
        }
        return "Potential XXE vulnerability. Insecure XML parser" + (String)parserString + " is used to process potentially tainted data " + prefix + " '%s' " + type + ".";
    }

    @Override
    protected boolean isSink(CtElement element) {
        if (!this.hasAnnotation(element, (Annotation)this.getSinkAnnotation())) {
            return false;
        }
        XmlParserSanitizationResolver resolver = new XmlParserSanitizationResolver(this.getJavaDataFlow(), this.annotationService, this.getSanitizationAnnotation(), FlagAnnotation.XML_PARSER_SOURCE, ((Object)((Object)this)).getClass());
        resolver.resolve(element);
        if (!this.hasAnnotation(element, (Annotation)this.getSanitizationAnnotation())) {
            this.xmlParsersDeclarations = resolver.getDeclarationPlaces();
            this.parser = this.getParser(element);
            return true;
        }
        return false;
    }

    private CtElement getParser(CtElement sink) {
        if (sink instanceof CtInvocation) {
            return ((CtInvocation)sink).getTarget();
        }
        throw new IllegalArgumentException("get " + String.valueOf(sink.getClass()) + " type. Expected CtInvocation type.");
    }

    @Override
    protected TaintRuleStrategy getStrategy() {
        return new TaintRule.DefaultStrategy(){

            @Override
            public boolean isStringsOnly() {
                return false;
            }
        };
    }

    @Override
    protected void visitTaintedElement(CtElement tainted) {
        List<TaintResult> result = this.getJavaDataFlow().scanTaint(tainted, this.getStrategy(), ((Object)((Object)this)).getClass());
        if (result == null || result.isEmpty()) {
            return;
        }
        Module module = this.getModule();
        for (TaintResult taintResult : result) {
            CtElement sink = taintResult.getSinkElement();
            String type = this.getTypeForMessage(sink);
            String prefix = this.getPrefixForMessage(sink);
            for (TaintSource dataSource : taintResult.getSources()) {
                CtElement dataSourceElement = dataSource.getElement();
                for (TaintResult parserResult : this.xmlParsersDeclarations) {
                    for (TaintSource parserSource : parserResult.getSources()) {
                        CtElement parserDeclaration = parserSource.getElement();
                        CtExecutable executableWithParserDeclaration = (CtExecutable)parserDeclaration.getParent(CtExecutable.class);
                        if (dataSourceElement.getParent(CtExecutable.class) != executableWithParserDeclaration && tainted.getParent(CtExecutable.class) != executableWithParserDeclaration) continue;
                        WarningLevel dataLevel = this.getLevel(dataSource);
                        WarningLevel warningLevel = dataLevel == this.getLevel(parserSource) ? dataLevel : WarningLevel.LEVEL_2;
                        this.getPatternBuilder().setLevel(warningLevel).setExtendedMessage(this.getExtendedMessage(prefix, type)).build().add(tainted, sink, dataSource).addSourcePosition(dataSourceElement, module).addSourcePosition(parserDeclaration, module);
                    }
                }
            }
        }
    }

    private WarningLevel getLevel(TaintSource result) {
        CtElement element = result.getElement();
        if (element instanceof CtParameter && !this.hasAnnotation(element.getParent(), (Annotation)FlagAnnotation.MAIN_METHOD)) {
            return WarningLevel.LEVEL_3;
        }
        return WarningLevel.LEVEL_1;
    }
}

