/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.annotation.FlagAnnotation;
import com.pvsstudio.annotation.matcher.InvocationMatcher;
import com.pvsstudio.annotation.matcher.builder.InvocationMatcherBuilder;
import com.pvsstudio.dataflow.java.DataFlow;
import com.pvsstudio.dataflow.taint.TaintResult;
import com.pvsstudio.dataflow.taint.stategy.Context;
import com.pvsstudio.dataflow.taint.stategy.TaintRuleStrategy;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.rules.TaintRule;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V5333
extends TaintRule {
    private final PvsStudioRule.PatternBuilder ruleBuilder = new PvsStudioRule.PatternBuilder().setCwe(502).setSastId("CERT-SER12-J").setSecId("SEC-TAINT").setMessage("Possible insecure deserialization vulnerability. Potentially tainted data is used to create an object during deserialization.");
    private static final List<InvocationMatcher> INVOCATION_MATCHERS = List.of(new InvocationMatcherBuilder("contains").anyParameters().build(), new InvocationMatcherBuilder("equals").anyParameters().build(), new InvocationMatcherBuilder("startsWith").anyParameters().build());
    private static final InvocationMatcher GETNAME_MATCHER = new InvocationMatcherBuilder("getName").anyParameters().build();

    @Override
    protected TaintRuleStrategy getStrategy() {
        return new TaintRule.DefaultStrategy(){

            @Override
            public boolean isStringsOnly() {
                return false;
            }

            @Override
            public boolean isSanitized(CtElement el, Context context) {
                return false;
            }
        };
    }

    @Override
    @Nullable
    protected PvsStudioRule.Pattern buildRule(TaintResult res, String prefix, String type, CtElement sink) {
        CtElement expParent = sink.getParent();
        if (!(expParent instanceof CtConstructorCall)) {
            return null;
        }
        CtConstructorCall constCall = (CtConstructorCall)expParent;
        CtTypeReference expType = constCall.getType();
        if (expType == null) {
            return null;
        }
        CtType declaredType = expType.getTypeDeclaration();
        if (declaredType == null) {
            return null;
        }
        if (declaredType.getQualifiedName().equals("java.io.ObjectInputStream")) {
            return super.buildRule(res, prefix, type, sink);
        }
        CtMethod targetMethod = declaredType.getMethodsByName("resolveClass").stream().filter(method -> method.getParameters().size() == 1 && ((CtParameter)method.getParameters().get(0)).getType() != null && ((CtParameter)method.getParameters().get(0)).getType().getQualifiedName().equals("java.io.ObjectStreamClass")).findFirst().orElse(null);
        if (targetMethod == null) {
            return super.buildRule(res, prefix, type, sink);
        }
        if (this.isObjectCheckedInResolveMethodHeuristic(targetMethod)) {
            return null;
        }
        return super.buildRule(res, prefix, type, sink);
    }

    private boolean isObjectCheckedInResolveMethodHeuristic(CtMethod<?> method) {
        DataFlow javaDataFlow = this.getJavaDataFlow();
        if (javaDataFlow == null) {
            return true;
        }
        CtParameter param = (CtParameter)method.getParameters().get(0);
        List<CtVariableAccess<?>> paramUsages = javaDataFlow.getVariableUsagesWithDependencies(param, method);
        for (CtVariableAccess<?> paramUsage : paramUsages) {
            CtInvocation parentInvocation;
            CtElement parentElement;
            CtElement usageParent = paramUsage.getParent();
            if (!(usageParent instanceof CtInvocation)) continue;
            CtInvocation invocation = (CtInvocation)usageParent;
            if (this.isVerificationInvocation(invocation)) {
                return this.isInvocationInTargetPosition(invocation);
            }
            if (!GETNAME_MATCHER.matches((CtElement)invocation) || !((parentElement = usageParent.getParent()) instanceof CtInvocation) || !this.isVerificationInvocation(parentInvocation = (CtInvocation)parentElement)) continue;
            return this.isInvocationInTargetPosition(parentInvocation);
        }
        return false;
    }

    private boolean isVerificationInvocation(CtInvocation<?> invocation) {
        for (InvocationMatcher matcher : INVOCATION_MATCHERS) {
            if (!matcher.matches(invocation)) continue;
            return true;
        }
        return false;
    }

    private boolean isInvocationInTargetPosition(CtInvocation<?> invocation) {
        CtIf invParent = RulesUtils.getParentBounded(invocation, invocation.getParent(CtBlock.class), CtIf.class);
        if (invParent == null) {
            return false;
        }
        return !invParent.getThenStatement().getElements((Filter)new TypeFilter(CtThrow.class)).isEmpty();
    }

    @Override
    protected FlagAnnotation getSanitizationAnnotation() {
        throw new UnsupportedOperationException("Shouldn't be used");
    }

    @Override
    protected FlagAnnotation getSinkAnnotation() {
        return FlagAnnotation.NATIVE_DESERIALIZATION_SINK;
    }

    @Override
    protected PvsStudioRule.PatternBuilder getPatternBuilder() {
        return this.ruleBuilder;
    }

    @Override
    protected boolean isOnlyWebSource() {
        return true;
    }

    @Override
    protected String getExtendedMessage(String prefix, String type) {
        return "Possible insecure deserialization vulnerability. Potentially tainted data " + prefix + " '%s' " + type + " is used to deserialize an object.";
    }
}

