/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.annotation.Annotation;
import com.pvsstudio.annotation.Annotations;
import com.pvsstudio.annotation.FlagAnnotation;
import com.pvsstudio.dataflow.taint.stategy.TaintRuleStrategy;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.rules.TaintRule;
import java.util.List;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;

public class V5332
extends TaintRule {
    private final PvsStudioRule.PatternBuilder ruleBuilder = new PvsStudioRule.PatternBuilder(this).setCwe(22).setSecId("SEC-TAINT").setMessage("Possible path traversal vulnerability. Potentially tainted data might be used to access files or folders outside a target directory.");

    @Override
    protected TaintRuleStrategy getStrategy() {
        return new TaintRule.DefaultStrategy(){

            @Override
            public boolean isBranchDirectionReversed(CtElement chainElement) {
                if (chainElement instanceof CtInvocation) {
                    CtExpression target;
                    CtInvocation invocation = (CtInvocation)chainElement;
                    Annotations annotations = V5332.this.annotationService.getAnnotations(chainElement);
                    if (annotations.contains((Annotation)FlagAnnotation.NORMALIZED_PATH_TRAVERSAL_SANITIZATION) && (target = invocation.getTarget()) instanceof CtAbstractInvocation) {
                        Annotations targetAnnotations = V5332.this.annotationService.getAnnotations((CtElement)target);
                        return targetAnnotations.contains((Annotation)FlagAnnotation.PATH_NORMALIZATION);
                    }
                }
                return false;
            }

            @Override
            public boolean isBlackListCommonSanitization(CtElement element) {
                return this.isBranchDirectionReversed(element);
            }

            @Override
            public boolean isStringsOnly() {
                return false;
            }

            @Override
            public boolean isTypeIgnored(CtTypeReference<?> type) {
                return this.ignorePrimitives().test(type);
            }
        };
    }

    @Override
    protected boolean isPublicConsideredSource() {
        return false;
    }

    @Override
    protected boolean isMainConsideredSource() {
        return false;
    }

    @Override
    protected boolean isInvocationCorrectHook(CtAbstractInvocation<?> inv) {
        CtExecutableReference executable = inv.getExecutable();
        CtTypeReference declaringType = executable.getDeclaringType();
        if (!"com.fasterxml.jackson.databind.ObjectMapper".equals(declaringType.getQualifiedName())) {
            return true;
        }
        List arguments = inv.getArguments();
        if (arguments.isEmpty()) {
            return true;
        }
        return RulesUtils.isSubtypeOf((CtExpression)arguments.get(0), "java.io.File", "java.nio.file.Path", "java.net.URL", "java.net.URI");
    }

    @Override
    protected PvsStudioRule.PatternBuilder getPatternBuilder() {
        return this.ruleBuilder;
    }

    @Override
    protected FlagAnnotation getSanitizationAnnotation() {
        return FlagAnnotation.PATH_TRAVERSAL_SANITIZATION;
    }

    @Override
    protected FlagAnnotation getSinkAnnotation() {
        return FlagAnnotation.PATH_TRAVERSAL_SINK;
    }

    @Override
    protected String getExtendedMessage(String prefix, String type) {
        return "Possible path traversal vulnerability. Potentially tainted data " + prefix + " '%s' " + type + " might be used to access files or folders outside a target directory.";
    }
}

