/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.google.common.net.InetAddresses;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.utility.network.Subnetwork;
import com.pvsstudio.warnings.WarningLevel;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;

public class V5331
extends PvsStudioRule {
    private static final Set<InetAddress> DIRECT_ALLOWED_ADDRESSES = Stream.of("255.255.255.255", "0.0.0.0", "::", "8.8.8.8", "8.8.4.4", "2001:4860:4860::8888", "2001:4860:4860::8844", "1.1.1.1", "1.0.0.1", "2606:4700:4700::1111", "2606:4700:4700::1001", "1.1.1.2", "1.0.0.2", "2606:4700:4700::1112", "2606:4700:4700::1002", "1.1.1.3", "1.0.0.3", "2606:4700:4700::1113", "2606:4700:4700::1003", "77.88.8.8", "77.88.8.1", "2a02:6b8::feed:0ff", "2a02:6b8:0:1::feed:0ff", "77.88.8.88", "77.88.8.2", "2a02:6b8::feed:bad", "2a02:6b8:0:1::feed:bad", "77.88.8.3", "77.88.8.7", "2a02:6b8::feed:a11", "2a02:6b8:0:1::feed:a11", "94.140.14.14", "94.140.15.15", "2a10:50c0::ad1:ff", "2a10:50c0::ad2:ff", "94.140.14.140", "94.140.14.141", "2a10:50c0::1:ff", "2a10:50c0::2:ff", "94.140.14.15", "94.140.15.16", "2a10:50c0::bad1:ff", "2a10:50c0::bad2:ff").map(InetAddresses::forString).collect(Collectors.toUnmodifiableSet());
    private static final List<Subnetwork> ALLOWED_SUBNETS = Stream.of("192.0.2.0/24", "198.51.100.0/24", "203.0.113.0/24", "2001:db8::/32", "198.18.0.0/15").map(Subnetwork::forString).collect(Collectors.toUnmodifiableList());
    private static final Map<String, String> KNOWN_POSSIBLE_ADDRESS_NAME_REPLACEMENT = Map.of("host.docker.internal", "172.17.0.1", "gateway.docker.internal", "172.17.0.1");
    private static final Pattern IPV4_PATTERN = Pattern.compile("\\d+\\.\\d+\\.\\d+\\.\\d+");
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("Avoid using hardcoded IP addresses, as this can expose network topology to an attacker.").setLevel(WarningLevel.LEVEL_3).setCwe(540).setCwe(1051).setSastId("CERT-MSC03-J").setSecId("SEC-SECURITY").build();

    public <T> void visitCtLiteral(@NotNull CtLiteral<T> literal) {
        this.lookupInExpression((CtExpression<?>)literal);
    }

    public <T, A extends T> void visitCtAssignment(@NotNull CtAssignment<T, A> assignment) {
        this.lookupInExpression(assignment.getAssignment());
    }

    @Override
    public <T> void visitCtInvocation(@NotNull CtInvocation<T> inv) {
        inv.getArguments().forEach(this::lookupInExpression);
    }

    public <T> void visitCtField(@NotNull CtField<T> field) {
        this.lookupInExpression(field.getAssignment());
    }

    public <T> void visitCtNewArray(@NotNull CtNewArray<T> newArray) {
        newArray.getElements().forEach(this::lookupInExpression);
    }

    private void lookupInExpression(@NotNull CtExpression<?> expression) {
        RulesUtils.lookupStringValue(this.getDataFlow(), expression).ifPresent(value -> this.checkStringValue(expression, (String)value));
    }

    private void checkStringValue(@NotNull CtExpression<?> expression, @NotNull String value) {
        if (this.isInsideTestSources((CtElement)expression) || this.isInsideExampleFile(expression)) {
            return;
        }
        value = V5331.translateKnownAddressNames(value);
        V5331.lookupInetAddresses(value).filter(V5331::isDisallowed).forEach(address -> this.rule.add((CtElement)expression, new Object[0]));
    }

    @NotNull
    private static String translateKnownAddressNames(@NotNull String value) {
        for (Map.Entry<String, String> entry : KNOWN_POSSIBLE_ADDRESS_NAME_REPLACEMENT.entrySet()) {
            String name = entry.getKey();
            String replacement = entry.getValue();
            value = value.replace(name, replacement);
        }
        return value;
    }

    @NotNull
    private static Stream<InetAddress> lookupInetAddresses(@NotNull String value) {
        if (value.startsWith("jdbc:")) {
            return IPV4_PATTERN.matcher(value).results().map(MatchResult::group).flatMap(V5331::lookupInetAddresses);
        }
        value = V5331.removePossibleSuffixes(value);
        try {
            return Stream.of(InetAddresses.forString((String)value));
        }
        catch (IllegalArgumentException ignored) {
            return Stream.empty();
        }
    }

    @NotNull
    private static String removePossibleSuffixes(@NotNull String value) {
        int lastColonIndex = value.lastIndexOf(58);
        if (lastColonIndex != -1 && lastColonIndex == value.indexOf(58)) {
            return value.substring(0, lastColonIndex);
        }
        int slashIndex = value.lastIndexOf(47);
        if (slashIndex != -1) {
            return value.substring(0, slashIndex);
        }
        return value;
    }

    private static boolean isDisallowed(@NotNull InetAddress address) {
        return !address.isLoopbackAddress() && !V5331.isPossibleOID(address) && !DIRECT_ALLOWED_ADDRESSES.contains(address) && !V5331.isInAllowedSubnet(address) && !V5331.isZeroStartingIpv4(address);
    }

    private static boolean isPossibleOID(@NotNull InetAddress address) {
        byte[] bytes = address.getAddress();
        return bytes.length == 4 && bytes[0] == 2 && bytes[1] == 5;
    }

    private static boolean isInAllowedSubnet(@NotNull InetAddress address) {
        return ALLOWED_SUBNETS.stream().anyMatch(subnetwork -> subnetwork.isInRange(address));
    }

    private static boolean isZeroStartingIpv4(@NotNull InetAddress address) {
        byte[] bytes = address.getAddress();
        return bytes.length == 4 && bytes[0] == 0;
    }
}

