/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.annotation.Annotation;
import com.pvsstudio.annotation.FlagAnnotation;
import com.pvsstudio.dataflow.taint.stategy.Context;
import com.pvsstudio.dataflow.taint.stategy.TaintRuleStrategy;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.rules.TaintRule;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtVariableReference;

public class V5330
extends TaintRule {
    private final PvsStudioRule.PatternBuilder ruleBuilder = new PvsStudioRule.PatternBuilder(this).setMessage("Possible XSS injection. Potentially tainted data might be used to execute a malicious script.").setSastId("OWASP-5.3.3").setSecId("SEC-TAINT").setCwe(79);
    private final String servlet = "jakarta.servlet.ServletResponse";
    private final String servletHttp = "jakarta.servlet.http.HttpServletResponse";
    private final String servletJavax = "javax.servlet.ServletResponse";
    private final String servletJavaxHttp = "javax.servlet.http.HttpServletResponse";
    private final String printWriter = "java.io.PrintWriter";
    private final String setHeader = "setHeader";
    private final String addHeader = "addHeader";
    private final List<String> unsafePolicyHints = Arrays.asList("'unsafe-inline'", "'unsafe-eval'", "*", "data:", "blob:");

    @Override
    protected PvsStudioRule.PatternBuilder getPatternBuilder() {
        return this.ruleBuilder;
    }

    @Override
    protected FlagAnnotation getSanitizationAnnotation() {
        return FlagAnnotation.EMPTY_ANNOTATION;
    }

    @Override
    protected FlagAnnotation getSinkAnnotation() {
        return FlagAnnotation.XSS_INJECTION_SINK;
    }

    @Override
    protected String getExtendedMessage(String prefix, String type) {
        return "Possible XSS injection. Potentially tainted data " + prefix + " '%s' " + type + " might be used to execute a malicious script.";
    }

    @Override
    protected boolean isOnlyWebSource() {
        return true;
    }

    @Override
    protected TaintRuleStrategy getStrategy() {
        return new TaintRule.DefaultStrategy(){

            @Override
            public boolean isSanitized(CtElement el, Context context) {
                if (context.getCurrentVariable() instanceof CtFieldReference && el instanceof CtInvocation && V5330.this.hasMethodFieldAnnotation((CtInvocation)el, (CtFieldReference)context.getCurrentVariable(), FlagAnnotation.XSS_INPUT_SANITIZATION)) {
                    return true;
                }
                if (el instanceof CtAbstractInvocation) {
                    return V5330.this.hasAnnotation(el, (Annotation)FlagAnnotation.XSS_INPUT_SANITIZATION);
                }
                return false;
            }
        };
    }

    @Override
    protected boolean isInvocationCorrectHook(CtAbstractInvocation<?> inv) {
        if (!inv.getExecutable().getDeclaringType().getQualifiedName().equals("java.io.PrintWriter")) {
            return true;
        }
        if (inv instanceof CtInvocation) {
            CtInvocation invocation = (CtInvocation)inv;
            String type = null;
            CtVariableRead read = null;
            if (invocation.getTarget() instanceof CtVariableRead) {
                CtVariableRead variableRead = (CtVariableRead)invocation.getTarget();
                CtElement element = this.getJavaDataFlow().getVariableExpression((CtVariableAccess<?>)variableRead, (CtElement)invocation);
                if (element instanceof CtInvocation && ((CtInvocation)element).getTarget() instanceof CtVariableRead) {
                    read = (CtVariableRead)((CtInvocation)element).getTarget();
                    CtVariableReference parent = read.getVariable();
                    type = parent.getType().getQualifiedName();
                }
            }
            if (invocation.getTarget() instanceof CtInvocation) {
                CtInvocation invocationTarget = (CtInvocation)invocation.getTarget();
                type = invocationTarget.getExecutable().getDeclaringType().getQualifiedName();
                while (invocationTarget.getTarget() instanceof CtTargetedExpression && invocationTarget.getTarget() instanceof CtInvocation) {
                    invocationTarget = (CtInvocation)invocationTarget.getTarget();
                }
                read = invocationTarget.getTarget() instanceof CtVariableRead ? (CtVariableRead)invocationTarget.getTarget() : null;
            }
            return !(type == null || !type.equals("jakarta.servlet.http.HttpServletResponse") && !type.equals("jakarta.servlet.ServletResponse") && !type.equals("javax.servlet.http.HttpServletResponse") && !type.equals("javax.servlet.ServletResponse") || read != null && this.areHeadersUsed((CtVariableAccess<?>)read));
        }
        return false;
    }

    private boolean areHeadersUsed(CtVariableAccess<?> reference) {
        List headers = this.getJavaDataFlow().getAllVariableUsages(reference.getVariable()).stream().filter(x -> x.getRoleInParent() == CtRole.TARGET).map(CtElement::getParent).map(x -> (CtInvocation)x).filter(x -> x.getExecutable() != null).filter(x -> x.getExecutable().getSimpleName().equals("setHeader") || x.getExecutable().getSimpleName().equals("addHeader")).filter(x -> "Content-Security-Policy".equals(RulesUtils.getStringFromExpression((CtExpression)x.getArguments().get(0))) && RulesUtils.getStringFromExpression((CtExpression)x.getArguments().get(1)) != null && this.unsafePolicyHints.stream().noneMatch(y -> ((String)RulesUtils.getStringFromExpression((CtExpression)x.getArguments().get(1))).contains((CharSequence)y))).collect(Collectors.toUnmodifiableList());
        return !headers.isEmpty();
    }
}

