/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.visitor.CtScanner;

public class V5329
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("Using non-atomic file creation is not recommended because an attacker might intercept file ownership.").setLevel(WarningLevel.LEVEL_1).setCwe(377).setSecId("SEC-SECURITY").build();

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> inv) {
        CtTypeAccess type;
        if (this.isInsideTestSources((CtElement)inv) || this.getJavaDataFlow() == null) {
            return;
        }
        CtExecutableReference executableReference = inv.getExecutable();
        if (inv.getTarget() instanceof CtTypeAccess && "java.io.File".equals((type = (CtTypeAccess)inv.getTarget()).getAccessedType().getQualifiedName()) && "createTempFile".equals(executableReference.getSimpleName())) {
            ArrayList<CtElement> usages = new ArrayList<CtElement>();
            if (inv.getParent() instanceof CtAssignment && ((CtAssignment)inv.getParent()).getAssigned() instanceof CtVariableWrite) {
                usages.addAll(this.getJavaDataFlow().getVariableUsages((CtElement)((CtAssignment)inv.getParent()).getAssigned(), (CtElement)inv));
            } else if (inv.getParent() instanceof CtLocalVariable) {
                usages.addAll(this.getJavaDataFlow().getVariableUsages(inv.getParent(), (CtElement)inv));
            }
            final AtomicBoolean hasMkdir = new AtomicBoolean(false);
            CtScanner scanner = new CtScanner(){

                public <T1> void visitCtInvocation(CtInvocation<T1> invocation) {
                    if (invocation.getExecutable().getSimpleName().equals("mkdir") || invocation.getExecutable().getSimpleName().equals("mkdirs")) {
                        hasMkdir.set(true);
                    }
                    super.visitCtInvocation(invocation);
                }
            };
            usages.forEach(arg_0 -> ((CtScanner)scanner).scan(arg_0));
            if (hasMkdir.get()) {
                this.rule.add((CtElement)inv, new Object[0]);
            }
        }
    }
}

