/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.annotation.matcher.Matcher;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Predicate;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V5328
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setMessage("Using non-restrictive authorization checks could lead to security violations.").setLevel(WarningLevel.LEVEL_2).setSastId("OWASP-4.1.5").setSecId("SEC-SECURITY").setCwe(285).build();
    private final Set<Matcher<CtTypeReference<?>>> springVoters = Set.of(Matcher.ofClass((String)"org.springframework.security.access.AccessDecisionVoter").build(), Matcher.ofClass((String)"org.springframework.security.access.PermissionEvaluator").build());

    public <R> void visitCtBlock(CtBlock<R> block) {
        if (block.getParent() instanceof CtExecutable) {
            CtExecutable executable = (CtExecutable)block.getParent();
            boolean isVote = executable.getSimpleName().equals("vote");
            boolean isHasPermission = executable.getSimpleName().equals("hasPermission");
            if (!isVote && !isHasPermission) {
                return;
            }
            CtClass clazz = (CtClass)executable.getParent((Filter)new TypeFilter(CtClass.class));
            if (clazz != null) {
                boolean foundSpringVoter = false;
                LinkedList interfaces = new LinkedList(clazz.getSuperInterfaces());
                for (int i = 0; i < interfaces.size(); ++i) {
                    CtTypeReference inter = (CtTypeReference)interfaces.get(i);
                    if (this.springVoters.stream().anyMatch(matcher -> matcher.matches((CtElement)inter))) {
                        foundSpringVoter = true;
                        break;
                    }
                    interfaces.addAll(inter.getSuperInterfaces());
                }
                if (foundSpringVoter) {
                    if (isVote) {
                        this.checkRule(executable, this::isStrongVoteDecision);
                    } else if (isHasPermission) {
                        this.checkRule(executable, this::isStrongHasPermissionDecision);
                    }
                }
            }
        }
    }

    private void checkRule(CtExecutable<?> executable, Predicate<CtExpression<?>> isStrongDecision) {
        ReturnStatementVisitor returnStatementVisitor = new ReturnStatementVisitor(isStrongDecision);
        returnStatementVisitor.scan((CtElement)executable);
        if (!returnStatementVisitor.isResult()) {
            this.rule.add((CtElement)executable, new Object[0]);
        }
    }

    private boolean isStrongHasPermissionDecision(CtExpression<?> expression) {
        Object value;
        if (expression instanceof CtLiteral && (value = ((CtLiteral)expression).getValue()) instanceof Boolean) {
            return (Boolean)value == false;
        }
        return true;
    }

    private boolean isStrongVoteDecision(CtExpression<?> expression) {
        if (expression instanceof CtLiteral || expression instanceof CtBinaryOperator || expression instanceof CtUnaryOperator) {
            return false;
        }
        if (expression instanceof CtFieldRead) {
            CtFieldRead ctFieldRead = (CtFieldRead)expression;
            String fieldName = ctFieldRead.getVariable().getFieldDeclaration().getReference().getSimpleName();
            if ("ACCESS_DENIED".equals(fieldName)) {
                return true;
            }
            return !"ACCESS_GRANTED".equals(fieldName) && !"ACCESS_ABSTAIN".equals(fieldName);
        }
        return true;
    }

    private static class ReturnStatementVisitor
    extends CtScanner {
        private final Predicate<CtExpression<?>> isStrongDecision;
        private boolean result = false;

        public ReturnStatementVisitor(Predicate<CtExpression<?>> isStrongDecision) {
            this.isStrongDecision = isStrongDecision;
        }

        public boolean isResult() {
            return this.result;
        }

        public <R> void visitCtReturn(CtReturn<R> ret) {
            CtExpression expression = ret.getReturnedExpression();
            if (expression != null && this.isStrongDecision.test(expression)) {
                this.result = true;
            }
        }

        public void visitCtThrow(CtThrow throwStatement) {
            this.result = true;
        }

        public <T> void visitCtLambda(CtLambda<T> lambda) {
        }

        public <T> void visitCtClass(CtClass<T> ctClass) {
        }
    }
}

