/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.annotation.Annotation;
import com.pvsstudio.annotation.FlagAnnotation;
import com.pvsstudio.dataflow.taint.stategy.Context;
import com.pvsstudio.dataflow.taint.stategy.TaintRuleStrategy;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.TaintRule;
import java.util.List;
import java.util.Optional;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class V5327
extends TaintRule {
    private final PvsStudioRule.PatternBuilder ruleBuilder = new PvsStudioRule.PatternBuilder().setCwe(20).setSecId("SEC-TAINT").setMessage("Possible regex injection. Potentially tainted data is used to create regular expression.");

    @Override
    protected boolean isPublicConsideredSource() {
        return false;
    }

    @Override
    protected PvsStudioRule.PatternBuilder getPatternBuilder() {
        return this.ruleBuilder;
    }

    @Override
    protected String getExtendedMessage(String prefix, String type) {
        return "Possible regex injection. Potentially tainted data " + prefix + " '%s' " + type + " is used to create regular expression.";
    }

    @Override
    protected TaintRuleStrategy getStrategy() {
        return new TaintRule.DefaultStrategy(){

            @Override
            public boolean isSanitized(CtElement el, Context context) {
                if (context.getCurrentVariable() instanceof CtFieldReference && el instanceof CtInvocation && V5327.this.hasMethodFieldAnnotation((CtInvocation)el, (CtFieldReference)context.getCurrentVariable(), FlagAnnotation.REGEX_SANITIZATION)) {
                    return true;
                }
                if (V5327.this.hasAnnotation(el, (Annotation)V5327.this.getSanitizationAnnotation())) {
                    if (el instanceof CtAbstractInvocation && V5327.this.hasAnnotation(el, (Annotation)FlagAnnotation.REGEX_TARGET_SANITIZATION)) {
                        List reads = el.getElements((Filter)new TypeFilter(CtVariableRead.class));
                        return reads.stream().anyMatch(x -> Optional.of(x).filter(y -> V5327.this.hasAnnotation((CtElement)y, (Annotation)FlagAnnotation.REGEX_SANITIZATION)).map(CtVariableAccess::getVariable).filter(y -> y.equals(context.getCurrentVariable())).isPresent());
                    }
                    return true;
                }
                if (V5327.this.hasAnnotation(el, (Annotation)FlagAnnotation.POTENTIAL_COMMON_SANITIZATION)) {
                    return true;
                }
                if (el instanceof CtTargetedExpression) {
                    CtExpression target = ((CtTargetedExpression)el).getTarget();
                    if (target == null) {
                        return false;
                    }
                    return this.isSanitized((CtElement)target, context);
                }
                if (el.getParent() instanceof CtBinaryOperator) {
                    CtBinaryOperator binary = (CtBinaryOperator)el.getParent();
                    return this.isSanitized((CtElement)binary, context);
                }
                return false;
            }
        };
    }

    @Override
    protected FlagAnnotation getSanitizationAnnotation() {
        return FlagAnnotation.REGEX_SANITIZATION;
    }

    @Override
    protected FlagAnnotation getSinkAnnotation() {
        return FlagAnnotation.REGEX_SINK;
    }
}

