/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtExecutableReference;

public class V5326
extends PvsStudioRule {
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder(this).setMessage("A password for a database connection should not be empty.").setLevel(WarningLevel.LEVEL_1).setSecId("SEC-SECURITY").setCwe(521).build();
    private final Map<String, Integer> methods = Map.ofEntries(Map.entry("java.sql.DriverManager.getConnection", 3), Map.entry("javax.sql.DataSource.getConnection", 2));
    private final List<String> markerWords = Arrays.asList("DataSource", "HikariConfig");

    public <T> void visitCtLiteral(CtLiteral<T> literal) {
        if (this.isInsideTestSources((CtElement)literal)) {
            return;
        }
        if (literal.getRoleInParent() == CtRole.ARGUMENT) {
            CtInvocation inv = (CtInvocation)literal.getParent(CtInvocation.class);
            if (inv == null) {
                return;
            }
            String invName = RulesUtils.getQualifiedName(inv);
            int pos = inv.getArguments().indexOf(literal);
            String str = RulesUtils.getStringFromDataFlow(this.getDataFlow(), literal);
            if (str != null && str.isEmpty() && (this.methods.containsKey(invName) && pos + 1 == this.methods.get(invName) || inv.getExecutable().getSimpleName().equals("setPassword") && Optional.of(inv).map(CtAbstractInvocation::getExecutable).map(CtExecutableReference::getDeclaration).map(x -> (CtClass)x.getParent(CtClass.class)).map(CtType::getSimpleName).filter(x -> this.markerWords.stream().anyMatch(x::contains)).isPresent())) {
                this.rule.add((CtElement)literal, new Object[0]);
            }
        }
    }
}

