/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.OptionalStringView;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.warnings.WarningLevel;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.support.reflect.code.CtNewArrayImpl;
import spoon.support.reflect.declaration.CtAnnotationImpl;

public class V5325
extends PvsStudioRule {
    private final PvsStudioRule.Pattern ruleEmptyParam = new PvsStudioRule.PatternBuilder(this).setMessage("Setting an empty 'origin' parameter in the 'CrossOrigin' annotation is potentially insecure.").setLevel(WarningLevel.LEVEL_1).setCwe(942).setSecId("SEC-SECURITY").build();
    private final PvsStudioRule.Pattern ruleStarParam = new PvsStudioRule.PatternBuilder(this).setMessage("Setting the value of the 'Access-Control-Allow-Origin' header to '*' is potentially insecure.").setLevel(WarningLevel.LEVEL_1).setCwe(942).setSecId("SEC-SECURITY").build();
    private final PvsStudioRule.Pattern ruleDefaultValues = new PvsStudioRule.PatternBuilder(this).setMessage("The 'applyPermitDefaultValues' method sets the value of the 'Access-Control-Allow-Origin' header to '*'. This is potentially insecure.").setLevel(WarningLevel.LEVEL_1).setCwe(942).setSecId("SEC-SECURITY").build();
    private final List<String> targetMethods = List.of("org.springframework.web.servlet.config.annotation.CorsRegistration.allowedOrigins", "org.springframework.web.cors.CorsConfiguration.applyPermitDefaultValues", "org.springframework.web.cors.CorsConfiguration.addAllowedOrigin", "jakarta.servlet.http.HttpServletResponse.setHeader");

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> inv) {
        String fullName = RulesUtils.getQualifiedName(inv);
        if (!this.targetMethods.contains(fullName)) {
            return;
        }
        switch (fullName) {
            case "org.springframework.web.cors.CorsConfiguration.applyPermitDefaultValues": {
                this.ruleDefaultValues.add((CtElement)inv, new Object[0]);
                break;
            }
            case "org.springframework.web.cors.CorsConfiguration.addAllowedOrigin": {
                this.applyValue((CtElement)inv.getArguments().get(0));
                break;
            }
            case "jakarta.servlet.http.HttpServletResponse.setHeader": {
                OptionalStringView firstParam = this.getValue((CtElement)inv.getArguments().get(0)).getVirtualValue().getSingletonString();
                if (!firstParam.isPresent() || !firstParam.get().equals("Access-Control-Allow-Origin")) {
                    return;
                }
                this.applyValue((CtElement)inv.getArguments().get(1));
                break;
            }
            case "org.springframework.web.servlet.config.annotation.CorsRegistration.allowedOrigins": {
                CtExpression invParam;
                Iterator iterator = inv.getArguments().iterator();
                while (iterator.hasNext() && !this.applyValue((CtElement)(invParam = (CtExpression)iterator.next()))) {
                }
                break;
            }
            default: {
                return;
            }
        }
    }

    public <T> void visitCtBlock(CtBlock<T> block) {
        CtElement parent = block.getParent();
        if (parent instanceof CtMethod) {
            this.handleAnnotations(parent.getAnnotations());
        }
    }

    public <T> void visitCtClass(CtClass<T> ctClass) {
        this.handleAnnotations(ctClass.getAnnotations());
    }

    private void handleAnnotations(List<CtAnnotation<?>> annotations) {
        annotations.stream().filter(ann -> ann != null && ann.getAnnotationType().toString().equals("org.springframework.web.bind.annotation.CrossOrigin")).findFirst().ifPresent(this::handleTargetAnnotation);
    }

    private void handleTargetAnnotation(CtAnnotation<?> ann) {
        Object originParamValue;
        Map annotationValues = ((CtAnnotationImpl)ann).getElementValues();
        if (annotationValues.isEmpty()) {
            this.ruleEmptyParam.add((CtElement)ann, new Object[0]);
            return;
        }
        if (annotationValues.containsKey("origins")) {
            this.handleArrayOfValues(annotationValues.get("origins"));
        } else if (annotationValues.containsKey("originsPattern")) {
            this.handleArrayOfValues(annotationValues.get("originsPattern"));
        } else if (annotationValues.containsKey("value") && (originParamValue = annotationValues.get("value")) instanceof CtLiteral && ((CtLiteral)originParamValue).getValue().equals("*")) {
            this.ruleStarParam.add((CtElement)originParamValue, new Object[0]);
        }
    }

    private void handleArrayOfValues(Object originParamValue) {
        if (originParamValue instanceof CtNewArrayImpl) {
            CtExpression annValue;
            Iterator iterator = ((CtNewArrayImpl)originParamValue).getElements().iterator();
            while (iterator.hasNext() && !this.applyValue((CtElement)(annValue = (CtExpression)iterator.next()))) {
            }
        } else if (originParamValue instanceof CtLiteral) {
            this.applyValue((CtElement)((CtLiteral)originParamValue));
        }
    }

    private boolean applyValue(CtElement element) {
        if (this.isStarValue(element)) {
            this.ruleStarParam.add(element, new Object[0]);
            return true;
        }
        return false;
    }

    private boolean isStarValue(CtElement element) {
        OptionalStringView targetString = this.getDataFlow().getValue(element).getVirtualValue().getSingletonString();
        if (!targetString.isPresent()) {
            return false;
        }
        return targetString.get().equals("*");
    }
}

