/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.annotation.FlagAnnotation;
import com.pvsstudio.core.OptionalStringView;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.RulesUtils;
import com.pvsstudio.rules.TaintRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtExpression;
import spoon.reflect.declaration.CtElement;

public class V5323
extends TaintRule {
    private final PvsStudioRule.PatternBuilder rule = new PvsStudioRule.PatternBuilder().setMessage("Potentially tainted data is used to configure CORS.").setLevel(WarningLevel.LEVEL_1).setCwe(942).setSecId("SEC-TAINT");

    @Override
    protected Collection<CtExpression<?>> findSinks(@NotNull CtAbstractInvocation<?> inv) {
        List args = inv.getArguments();
        if (args.size() < 2) {
            return List.of();
        }
        if (!RulesUtils.getTypeName((CtExpression)args.get(0)).equals("java.lang.String") || !RulesUtils.getTypeName((CtExpression)args.get(1)).equals("java.lang.String")) {
            return List.of();
        }
        OptionalStringView headerArg = this.getValue((CtElement)args.get(0)).getVirtualValue().getSingletonString();
        if (headerArg.isPresent() && headerArg.get().equals("Access-Control-Allow-Origin")) {
            return List.of((CtExpression)inv.getArguments().get(1));
        }
        return List.of();
    }

    @Override
    protected PvsStudioRule.PatternBuilder getPatternBuilder() {
        return this.rule;
    }

    @Override
    protected FlagAnnotation getSanitizationAnnotation() {
        return FlagAnnotation.CORS_SANITIZATION;
    }

    @Override
    protected FlagAnnotation getSinkAnnotation() {
        return FlagAnnotation.CORS_SINK;
    }

    @Override
    protected String getExtendedMessage(String prefix, String type) {
        return "Potentially tainted data " + prefix + " '%s' " + type + " is used to define the 'Access-Control-Allow-Origin' header.";
    }

    @Override
    protected boolean isOnlyWebSource() {
        return true;
    }
}

