/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.annotation.Annotation;
import com.pvsstudio.annotation.FlagAnnotation;
import com.pvsstudio.dataflow.taint.stategy.TaintRuleStrategy;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.TaintRule;
import java.util.Optional;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.reference.CtParameterReference;

public class V5322
extends TaintRule {
    private final PvsStudioRule.PatternBuilder ruleBuilder = new PvsStudioRule.PatternBuilder(this).setCwe(470).setSecId("SEC-TAINT").setMessage("Possible reflection injection. Potentially tainted data is used to select class or method.");

    @Override
    protected PvsStudioRule.PatternBuilder getPatternBuilder() {
        return this.ruleBuilder;
    }

    @Override
    protected FlagAnnotation getSanitizationAnnotation() {
        return FlagAnnotation.REFLECTION_SANITIZATION;
    }

    @Override
    protected FlagAnnotation getSinkAnnotation() {
        return FlagAnnotation.REFLECTION_INJECTION_SINK;
    }

    @Override
    protected String getExtendedMessage(String prefix, String type) {
        return "Potentially tainted data " + prefix + " '%s' " + type + " is used to select class or method.";
    }

    @Override
    protected TaintRuleStrategy getStrategy() {
        return new TaintRule.DefaultStrategy(){

            @Override
            public boolean isSource(CtElement el, CtExecutable<?> currentExecutable) {
                if (el instanceof CtParameterReference) {
                    return Optional.ofNullable(currentExecutable).filter(parent -> parent instanceof CtMethod).filter(parent -> V5322.this.hasAnnotation((CtElement)parent, (Annotation)FlagAnnotation.MAIN_METHOD) || V5322.this.hasAnnotation((CtElement)parent, (Annotation)FlagAnnotation.CONTROLLER_METHOD)).isPresent();
                }
                if (el instanceof CtInvocation) {
                    return V5322.this.annotationService.getAnnotations(el).contains((Annotation)FlagAnnotation.COMMON_SOURCE);
                }
                return false;
            }
        };
    }
}

