/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.annotation.Annotation;
import com.pvsstudio.annotation.Annotations;
import com.pvsstudio.annotation.FlagAnnotation;
import com.pvsstudio.dataflow.taint.stategy.TaintRuleStrategy;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.TaintRule;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.reference.CtParameterReference;

public class V5320
extends TaintRule {
    private final PvsStudioRule.PatternBuilder ruleBuilder = new PvsStudioRule.PatternBuilder().setCwe(15).setSecId("SEC-TAINT").setMessage("Use of potentially tainted data in configuration settings may cause security issues.");

    @Override
    protected PvsStudioRule.PatternBuilder getPatternBuilder() {
        return this.ruleBuilder;
    }

    @Override
    protected FlagAnnotation getSanitizationAnnotation() {
        return FlagAnnotation.CONFIGURATION_SANITIZATION;
    }

    @Override
    protected FlagAnnotation getSinkAnnotation() {
        return FlagAnnotation.CONFIGURATION_INJECTION_SINK;
    }

    @Override
    protected String getExtendedMessage(String prefix, String type) {
        return "Potentially tainted data " + prefix + " '%s' " + type + " is used in configuration settings. This may cause security issues.";
    }

    @Override
    protected TaintRuleStrategy getStrategy() {
        return new TaintRule.DefaultStrategy(){

            @Override
            public boolean isSource(CtElement el, CtExecutable<?> currentExecutable) {
                if (el instanceof CtParameterReference) {
                    if (currentExecutable instanceof CtMethod) {
                        if (V5320.this.hasAnnotation((CtElement)currentExecutable, (Annotation)FlagAnnotation.MAIN_METHOD)) {
                            return true;
                        }
                        if (V5320.this.hasAnnotation((CtElement)currentExecutable, (Annotation)FlagAnnotation.CONTROLLER_METHOD)) {
                            return true;
                        }
                        return ((CtMethod)currentExecutable).isPublic();
                    }
                } else if (el instanceof CtInvocation) {
                    Annotations annotations = V5320.this.annotationService.getAnnotations(el);
                    return annotations.contains((Annotation)FlagAnnotation.COMMON_SOURCE) && !annotations.contains((Annotation)FlagAnnotation.PROPERTY_SOURCE);
                }
                return false;
            }
        };
    }
}

