/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.annotation.Annotation;
import com.pvsstudio.annotation.FlagAnnotation;
import com.pvsstudio.annotation.matcher.Matcher;
import com.pvsstudio.dataflow.taint.stategy.TaintRuleStrategy;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.rules.TaintRule;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtTypeReference;

public class V5319
extends TaintRule {
    private final PvsStudioRule.PatternBuilder ruleBuilder = new PvsStudioRule.PatternBuilder().setCwe(117).setSastId("OWASP-7.3.1").setSecId("SEC-TAINT").setMessage("Possible log injection. Potentially tainted data is written into logs.");
    private final Matcher<CtTypeReference<?>> stringMatcher = Matcher.ofClass(String.class).build();

    @Override
    protected PvsStudioRule.PatternBuilder getPatternBuilder() {
        return this.ruleBuilder;
    }

    @Override
    protected FlagAnnotation getSanitizationAnnotation() {
        return FlagAnnotation.LOG_SANITIZATION;
    }

    @Override
    protected FlagAnnotation getSinkAnnotation() {
        return FlagAnnotation.LOG_INJECTION_SINK;
    }

    @Override
    protected String getExtendedMessage(String prefix, String type) {
        return "Possible log injection. Potentially tainted data " + prefix + " '%s' " + type + " is written into logs.";
    }

    @Override
    protected TaintRuleStrategy getStrategy() {
        return new TaintRule.DefaultStrategy(){

            @Override
            public boolean isSource(CtElement el, CtExecutable<?> currentExecutable) {
                if (el instanceof CtParameterReference) {
                    return Optional.ofNullable(currentExecutable).filter(parent -> parent instanceof CtMethod).filter(parent -> V5319.this.hasAnnotation((CtElement)parent, (Annotation)FlagAnnotation.MAIN_METHOD) || V5319.this.hasAnnotation((CtElement)parent, (Annotation)FlagAnnotation.CONTROLLER_METHOD)).isPresent();
                }
                if (el instanceof CtInvocation) {
                    return V5319.this.annotationService.getAnnotations(el).contains((Annotation)FlagAnnotation.COMMON_SOURCE);
                }
                return false;
            }
        };
    }

    @Override
    protected Collection<CtExpression<?>> findSinks(@NotNull CtAbstractInvocation<?> inv) {
        List args = inv.getArguments();
        List<CtExpression<?>> stringArguments = args.stream().filter(e -> Objects.nonNull(e.getType())).filter(e -> this.stringMatcher.matches((CtElement)e.getType())).collect(Collectors.toList());
        if (!stringArguments.isEmpty()) {
            return stringArguments;
        }
        return super.findSinks(inv);
    }
}

