/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.rules;

import com.pvsstudio.core.OptionalStringView;
import com.pvsstudio.core.VirtualValue;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.warnings.WarningLevel;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import spoon.Launcher;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.path.CtRole;
import spoon.reflect.reference.CtExecutableReference;

public class V5318
extends PvsStudioRule {
    private static final Launcher launcher = new Launcher();
    private static final CtInvocation<?> execInvocation = (CtInvocation)launcher.getFactory().createCodeSnippetExpression("Runtime.getRuntime().exec(\"java\")").compile();
    private final PvsStudioRule.Pattern rule = new PvsStudioRule.PatternBuilder().setCwe(266).setSastId("CERT-FIO01-J, OWASP-4.1.3").setSecId("SEC-SECURITY").setMessage("Setting loose POSIX file permissions (%s) is security-sensitive.").setLevel(WarningLevel.LEVEL_2).build();
    private final Pattern pattern = Pattern.compile("^.{6}(r(.?){2}|.w.?|.{2}x)");

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> inv) {
        if (this.isInsideTestSources((CtElement)inv)) {
            return;
        }
        CtExpression target = inv.getTarget();
        if (target == null) {
            return;
        }
        if (this.checkPermissionsFromString(inv)) {
            return;
        }
        this.checkChmod(inv);
    }

    private boolean checkPermissionsFromString(CtInvocation<?> inv) {
        CtExpression str;
        if (!inv.getExecutable().getSimpleName().equals("fromString")) {
            return false;
        }
        CtExpression target = inv.getTarget();
        if (!target.toString().equals("java.nio.file.attribute.PosixFilePermissions")) {
            return false;
        }
        if (inv.getRoleInParent() != CtRole.ARGUMENT) {
            return false;
        }
        CtExpression ctExpression = str = inv.getArguments().isEmpty() ? null : (CtExpression)inv.getArguments().get(0);
        if (str == null) {
            return false;
        }
        OptionalStringView strValue = this.getValue((CtElement)str).getVirtualValue().getSingletonString();
        if (!strValue.isPresent()) {
            return false;
        }
        String arg = strValue.get();
        if (this.pattern.matcher(arg).matches()) {
            this.rule.add((CtElement)inv, arg);
            return true;
        }
        return false;
    }

    private void checkChmod(CtInvocation<?> inv) {
        String[] arguments;
        CtExecutableReference executable = inv.getExecutable();
        CtExecutableReference execExecutable = execInvocation.getExecutable();
        if (!execExecutable.equals((Object)executable)) {
            return;
        }
        CtExpression argument = (CtExpression)inv.getArguments().get(0);
        if (argument == null) {
            return;
        }
        VirtualValue virtualValue = this.getValue((CtElement)argument).getVirtualValue();
        if (virtualValue == null) {
            return;
        }
        OptionalStringView stringValue = virtualValue.getSingletonString();
        if (!stringValue.isPresent()) {
            return;
        }
        String stringArgument = stringValue.get();
        int chmodIndex = stringArgument.indexOf("chmod");
        if (chmodIndex == -1) {
            return;
        }
        stringArgument = stringArgument.substring(chmodIndex);
        for (String arg : arguments = stringArgument.split(" ")) {
            String[] args;
            if (arg.startsWith("-")) continue;
            for (String splitArg : args = arg.split(",")) {
                if (splitArg.startsWith("a") || splitArg.startsWith("o")) {
                    if (splitArg.length() == 1) {
                        return;
                    }
                    if (splitArg.charAt(1) == '-') {
                        return;
                    }
                    if (StringUtils.containsAny((CharSequence)splitArg.substring(1), (CharSequence[])new CharSequence[]{"w", "r", "x"})) {
                        this.rule.add((CtElement)inv, splitArg);
                        return;
                    }
                }
                if (!StringUtils.isNumeric((CharSequence)splitArg)) continue;
                if (splitArg.length() != 3) {
                    return;
                }
                if (splitArg.charAt(2) != '0') {
                    this.rule.add((CtElement)inv, splitArg);
                }
                return;
            }
        }
    }
}

